/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/15 9:46:30
 */
package org.asyrinx.brownie.tapestry.seasar;

import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IEngine;
import org.seasar.framework.container.S2Container;

/**
 * @author takeshi
 */
public class S2ContainerStrategyImpl implements IS2ContainerStrategy {

    /**
     *  
     */
    public S2ContainerStrategyImpl(IComponent owner) {
        super();
        this.owner = owner;
    }

    protected final IComponent owner;

    public S2Container getS2Container() {
        final IEngine engine = owner.getPage().getEngine();
        if (!(engine instanceof S2AppEngine))
            throw new ApplicationRuntimeException("EntityDetailLink must work with " + S2AppEngine.class.getName());
        final S2AppEngine s2engine = (S2AppEngine) engine;
        final S2Container result = s2engine.getContainer();
        if (result == null)
            throw new ApplicationRuntimeException("S2Container was not found in global object.");
        return result;
    }
}