/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/08
 */
package org.asyrinx.brownie.tapestry.script;

import org.apache.tapestry.IComponent;
import org.apache.tapestry.IRequestCycle;

/**
 * @author akima
 */
public abstract class ScriptUsage {

	public boolean canWrite(IComponent component, IRequestCycle cycle) {
		final String key = key(component);
		final boolean result = cycle.getAttribute(key) == null;
		if (result)
			cycle.setAttribute(key, this);
		return result;
	}

	protected String key(IComponent component) {
		return null;
	}

	public static final ScriptUsage ONCE_BY_CLASS = new ScriptUsage() {
		protected String key(IComponent component) {
			return component.getClass().getName();
		}
	};

	public static final ScriptUsage ONCE_BY_OBJECT = new ScriptUsage() {
		protected String key(IComponent component) {
			return component.getClass().getName() + "." + component.hashCode();
		}
	};

	public static final ScriptUsage EVERYTIME = new ScriptUsage() {
		public boolean canWrite(IComponent component, IRequestCycle cycle) {
			return true;
		}
	};

}