/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/04
 */
package org.asyrinx.brownie.tapestry.components.link;

import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.components.ILinkComponent;
import org.asyrinx.brownie.core.lang.StringUtils;

/**
 * @author akima
 */
public abstract class AbstractLinkRowRenderer extends
		AbstractScriptLinkRenderer {

	/**
	 * @param scriptName
	 */
	public AbstractLinkRowRenderer(String scriptName) {
		super(scriptName);
	}

	public static final String CLICK_LINK_ROW_METHOD_NAME = "clickLinkRow";

	public static final String MOSUE_OVER_LINK_ROW_METHOD_NAME = "mouseOverLinkRow";

	public static final String MOSUE_OUT_LINK_ROW_METHOD_NAME = "mouseOutLinkRow";

	/**
	 * @see org.asyrinx.brownie.tapestry.components.link.AbstractScriptLinkRenderer#renderBeginTag(org.apache.tapestry.IMarkupWriter,
	 *      org.apache.tapestry.IRequestCycle,
	 *      org.apache.tapestry.components.ILinkComponent)
	 */
	protected void renderBeginTag(IMarkupWriter writer, IRequestCycle cycle,
			ILinkComponent linkComponent) {
		if (getHasBody())
			writer.begin(getElement());
		else
			writer.beginEmpty(getElement());
		writer.attribute("onclick", CLICK_LINK_ROW_METHOD_NAME + "(this)");
		writer.attribute("onmouseover", MOSUE_OVER_LINK_ROW_METHOD_NAME
				+ "(this)");
		writer.attribute("onmouseout", MOSUE_OUT_LINK_ROW_METHOD_NAME
				+ "(this)");
	}

	/**
	 * @return
	 */
	private String getElement() {
		return "tr";
	}

	/**
	 * this method is called from ScriptLinkRenderer.script
	 */
	public boolean isSelectStyleClassAvailable() {
		return !StringUtils.isEmpty(getSelectStyleClass());
	}

	private String selectBgColor = "lightseagreen";

	private String selectStyleClass = "";

	/**
	 * @return
	 */
	public String getSelectBgColor() {
		return selectBgColor;
	}

	/**
	 * @return
	 */
	public String getSelectStyleClass() {
		return selectStyleClass;
	}

	/**
	 * @param string
	 */
	public void setSelectBgColor(String string) {
		selectBgColor = string;
	}

	/**
	 * @param string
	 */
	public void setSelectStyleClass(String string) {
		selectStyleClass = string;
	}

}