/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/08
 */
package org.asyrinx.brownie.tapestry.components.layer;

import java.util.Map;

import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;

/**
 * @author akima
 */
public abstract class PopupLink extends AbstractDesktopComponent {

	/**
	 * @param scriptName
	 */
	public PopupLink() {
		super("PopupLink.script");
		this.setBackGroundColor(null);
	}

	//	<input-symbol key="id" class="java.labg.String" required="yes"/>
	//	<input-symbol key="desktop_id" class="java.labg.String" required="yes"/>
	//	<input-symbol key="left" class="int" required="yes"/>
	//	<input-symbol key="top" class="int" required="yes"/>
	//	<input-symbol key="popup_id" class="java.labg.String" required="yes"/>
	/**
	 * @see org.asyrinx.brownie.tapestry.script.AbstractScriptComponent#prepareScriptSymbols(java.util.Map,
	 *      org.apache.tapestry.IRequestCycle)
	 */
	public void prepareScriptSymbols(Map symbols, IRequestCycle cycle) {
		super.prepareScriptSymbols(symbols, cycle);
		symbols.put("popup_id", getPopupId());
	}

	/**
	 * @see org.asyrinx.brownie.tapestry.script.AbstractScriptComponent#renderComponent(org.apache.tapestry.IMarkupWriter,
	 *      org.apache.tapestry.IRequestCycle)
	 */
	protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
		checkBeforeRender(writer, cycle);
		this.scriptWriter.execute(cycle);

		writer.begin("div");
		writer.attribute("id", getStyleId());
		writer.attribute("style", "VISIBILITY:hidden; TEXT-ALIGN:center; "
				+ toStyleValue());
		renderInformalParameters(writer, cycle);
		writer.println();

		writer.begin("a");
		writer.attribute("href", "javascript:void(0);");
		writer.attribute("onclick", "link_" + getStyleId() + "_click();");
		writer.attribute("style", "TEXT-DECORATION:none");
		writer.println();

		final IMarkupWriter nested = writer.getNestedWriter();
		renderBody(nested, cycle);

		// Close the nested writer, which dumps its buffered content
		// into its parent.
		nested.close();
		writer.end(); // <a>
		writer.end(); // <div>
	}

	abstract public String getPopupId();

	abstract public void setPopupId(String string);
}