/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/08
 */
package org.asyrinx.brownie.tapestry.components.layer;

import java.util.Map;

import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;

/**
 * @author akima
 */
public abstract class AbstractDesktopComponent extends AbstractLayerComponent {

	/**
	 * @param scriptName
	 */
	protected AbstractDesktopComponent(String scriptName) {
		super(scriptName);
	}

	/**
	 * @see org.asyrinx.brownie.tapestry.script.AbstractScriptComponent#checkBeforeRender(org.apache.tapestry.IMarkupWriter,
	 *      org.apache.tapestry.IRequestCycle)
	 */
	protected void checkBeforeRender(IMarkupWriter writer, IRequestCycle cycle) {
		if (writer == null)
			throw new ApplicationRuntimeException("no way to write!", this,
					null, null);
		final Desktop desktop = Desktop.get(cycle);
		if (desktop == null)
			throw new ApplicationRuntimeException(
					Tapestry
							.getMessage("AbstractDesktopComponent.must-be-contained-by-form"),
					this, null, null);
	}

	/**
	 * @see org.asyrinx.brownie.tapestry.components.layer.AbstractLayerComponent#prepareScriptSymbols(java.util.Map,
	 *      org.apache.tapestry.IRequestCycle)
	 */
	public void prepareScriptSymbols(Map symbols, IRequestCycle cycle) {
		super.prepareScriptSymbols(symbols, cycle);
		symbols.put("desktop_id", Desktop.get(cycle).getStyleId());
	}

}