/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/13
 */
package org.asyrinx.brownie.tapestry.components.form;

import org.apache.commons.lang.enum.Enum;
import org.apache.tapestry.form.IPropertySelectionModel;

/**
 * @author akima
 */
public class SimpleEnumPropertySelectionModel implements
		IPropertySelectionModel {

	/**
	 *  
	 */
	public SimpleEnumPropertySelectionModel(Enum[] enums) {
		super();
		this.enums = enums;
	}

	private final Enum[] enums;

	/**
	 * @see org.apache.tapestry.form.IPropertySelectionModel#getOptionCount()
	 */
	public int getOptionCount() {
		return enums.length;
	}

	/**
	 * @see org.apache.tapestry.form.IPropertySelectionModel#getOption(int)
	 */
	public Object getOption(int index) {
		return enums[index];
	}

	/**
	 * @see org.apache.tapestry.form.IPropertySelectionModel#getLabel(int)
	 */
	public String getLabel(int index) {
		return enums[index].getName();
	}

	/**
	 * @see org.apache.tapestry.form.IPropertySelectionModel#getValue(int)
	 */
	public String getValue(int index) {
		return Integer.toString(index);
	}

	/**
	 * @see org.apache.tapestry.form.IPropertySelectionModel#translateValue(java.lang.String)
	 */
	public Object translateValue(String value) {
		int index = Integer.parseInt(value);
		return enums[index];
	}
}