/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/09/07 14:38:07
 */
package org.asyrinx.brownie.swing.table.key;

import java.util.Comparator;

import org.asyrinx.brownie.core.util.ArrayComparator;

/**
 * @author akima
 */
public class RowKeyComparator implements Comparator {

    /**
     *  
     */
    public RowKeyComparator() {
        super();
    }

    protected final Comparator comparator = new ArrayComparator();

    /*
     * (non-Javadoc)
     * 
     * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
     */
    public int compare(Object o1, Object o2) {
        if ((o1 instanceof RowKey) && (o2 instanceof RowKey)) {
            final RowKey key1 = (RowKey) o1;
            final RowKey key2 = (RowKey) o2;
            return comparator.compare(key1.getValues(), key2.getValues());
        }
        return 0;
    }

}