/*
 * brownies and its relative products are published under the terms of the
 * Apache Software License.
 * 
 * Created on 2004/05/22 16:07:34
 */
package org.asyrinx.brownie.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class AbsoluteLayout implements LayoutManager2, Serializable {

	protected final Map constraintMap = new Hashtable();

	public AbsoluteLayout() {
		//do nothing		
	}

	public void addLayoutComponent(Component component, Object obj) {
		if (!(obj instanceof AbsoluteConstraints)) {
			throw new IllegalArgumentException();
		} else {
			constraintMap.put(component, obj);
			return;
		}
	}

	public void addLayoutComponent(String s, Component component) {
		throw new IllegalArgumentException();
	}

	public void removeLayoutComponent(Component component) {
		constraintMap.remove(component);
	}

	public float getLayoutAlignmentX(Container container) {
		return 0.0F;
	}

	public float getLayoutAlignmentY(Container container) {
		return 0.0F;
	}

	public void invalidateLayout(Container container) {
		//do nothing
	}

	public void layoutContainer(Container container) {
		for (Iterator iterator = constraintMap.keySet().iterator(); iterator
				.hasNext();) {
			final Component component = (Component) iterator.next();
			final AbsoluteConstraints constraints = (AbsoluteConstraints) constraintMap
					.get(component);
			Dimension dimension = component.getPreferredSize();
			int i = constraints.getWidth();
			if (i == -1)
				i = dimension.width;
			int j = constraints.getHeight();
			if (j == -1)
				j = dimension.height;
			component.setBounds(constraints.x, constraints.y, i, j);
		}

	}

	public Dimension maximumLayoutSize(Container container) {
		return new Dimension(2147483647, 2147483647);
	}

	public Dimension minimumLayoutSize(Container container) {
		int i = 0;
		int j = 0;
		for (Iterator iterator = constraintMap.keySet().iterator(); iterator
				.hasNext();) {
			final Component component = (Component) iterator.next();
			final AbsoluteConstraints constraints = (AbsoluteConstraints) constraintMap
					.get(component);
			Dimension dimension = component.getMinimumSize();
			int k = constraints.getWidth();
			if (k == -1)
				k = dimension.width;
			int l = constraints.getHeight();
			if (l == -1)
				l = dimension.height;
			if (constraints.x + k > i)
				i = constraints.x + k;
			if (constraints.y + l > j)
				j = constraints.y + l;
		}

		return new Dimension(i, j);
	}

	public Dimension preferredLayoutSize(Container container) {
		int i = 0;
		int j = 0;
		for (Iterator iterator = constraintMap.keySet().iterator(); iterator
				.hasNext();) {
			final Component component = (Component) iterator.next();
			final AbsoluteConstraints absoluteconstraints = (AbsoluteConstraints) constraintMap
					.get(component);
			final Dimension dimension = component.getPreferredSize();
			int k = absoluteconstraints.getWidth();
			if (k == -1)
				k = dimension.width;
			int l = absoluteconstraints.getHeight();
			if (l == -1)
				l = dimension.height;
			if (absoluteconstraints.x + k > i)
				i = absoluteconstraints.x + k;
			if (absoluteconstraints.y + l > j)
				j = absoluteconstraints.y + l;
		}

		return new Dimension(i, j);
	}

}