/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/04/09 14:33:40
 */
package org.asyrinx.brownie.seasar.servlet;

import javax.servlet.ServletContext;

import org.asyrinx.brownie.seasar.container.factory.BrownieS2ContainerFactory;
import org.asyrinx.brownie.servlet.FileNameResolver;
import org.seasar.framework.container.S2Container;

/**
 * @author akima
 */
public class S2ContainerLoader {

    public static final String SERVLET_CONTEXT_PARAM_INITFILE = "s2config";

    public static final String SERVLET_CONTEXT_ATTRIBUTE_CONTAINER = S2ContainerLoader.class.getName() + ".container";

    public S2ContainerLoader(ServletContext context) {
        this.context = context;
        this.resolver = new FileNameResolver(this.context);
    }

    private final ServletContext context;

    private final FileNameResolver resolver;

    private S2Container createContainerByBrownie() {
        final String webContextRealPath = resolver.getContextRootPath();
        final String s2config = context.getInitParameter(SERVLET_CONTEXT_PARAM_INITFILE);
        return BrownieS2ContainerFactory.create(s2config, webContextRealPath);
    }

    public S2Container createContainer() {
        return createContainerByBrownie();
    }

    private S2Container container = null;

    public void initializeContainer() {
        container = createContainer();
        this.context.setAttribute(SERVLET_CONTEXT_ATTRIBUTE_CONTAINER, container);
    }

    public void finalizeContainer() {
        if (container != null)
            container.destroy();
    }

    public static S2Container getContainer(ServletContext context) {
        return (S2Container) context.getAttribute(SERVLET_CONTEXT_ATTRIBUTE_CONTAINER);
    }
}