/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/28 15:02:31
 */
package org.asyrinx.brownie.seasar.dbcp.wrapper;

import java.sql.SQLException;

import org.seasar.extension.dbcp.ConnectionPool;
import org.seasar.extension.dbcp.ConnectionWrapper;

/**
 * @author takeshi
 */
public class ConnectionPoolWrapper implements ConnectionPool {

    /**
     *  
     */
    public ConnectionPoolWrapper(ConnectionPool wrapped) {
        super();
        this.wrapped = wrapped;
    }

    protected final ConnectionPool wrapped;

    public void checkIn(ConnectionWrapper connectionWrapper) {
        wrapped.checkIn(connectionWrapper);
    }

    public ConnectionWrapper checkOut() throws SQLException {
        return wrapped.checkOut();
    }

    public void close() {
        wrapped.close();
    }

    public int getActivePoolSize() {
        return wrapped.getActivePoolSize();
    }

    public int getFreePoolSize() {
        return wrapped.getFreePoolSize();
    }

    public int getMaxPoolSize() {
        return wrapped.getMaxPoolSize();
    }

    public int getTxActivePoolSize() {
        return wrapped.getTxActivePoolSize();
    }

    public void release(ConnectionWrapper connectionWrapper) {
        wrapped.release(connectionWrapper);
    }
}