/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/06/11 1:59:34
 */
package org.asyrinx.brownie.seasar.container.factory;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import org.asyrinx.brownie.core.io.sf.StreamFactoryFacade;
import org.seasar.framework.container.ExtensionNotFoundRuntimeException;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerBuilder;
import org.seasar.framework.container.factory.S2ContainerFactory;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.PropertiesUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;

/**
 * @author akima
 */
public final class BrownieS2ContainerFactory {

    private static Properties builderProps_ = new Properties();

    private static Map defaultBuilders = new HashMap();

    /*
     * ςĂ܂B
     */
    private static S2ContainerBuilder defaultBuilder_ = new BrownieXmlS2ContainerBuilder();

    static {
        if (ResourceUtil.isExist(S2ContainerFactory.BUILDER_CONFIG_PATH)) {
            PropertiesUtil
                    .load(builderProps_, ResourceUtil.getResourceAsStream(S2ContainerFactory.BUILDER_CONFIG_PATH));
        }
        defaultBuilders.put("xml", defaultBuilder_);
        defaultBuilders.put("dicon", defaultBuilder_);
    }

    private static S2ContainerBuilder getDefaultBuilder(String ext) {
        S2ContainerBuilder builder = (S2ContainerBuilder) defaultBuilders.get(ext);
        if (builder != null) {
            return builder;
        }
        synchronized (defaultBuilders) {
            builder = (S2ContainerBuilder) defaultBuilders.get(ext);
            if (builder != null) {
                return builder;
            }
            final String className = builderProps_.getProperty(ext);
            if (className != null) {
                builder = (S2ContainerBuilder) ClassUtil.newInstance(className);
                defaultBuilders.put(ext, builder);
            } else {
                builder = defaultBuilder_;
            }
        }
        return builder;
    }

    private final Map builders = new HashMap();

    private BrownieS2ContainerFactory() {
        //do nothing
    }

    private BrownieS2ContainerFactory(String baseDirs) {
        this();
        final StreamFactoryFacade sff = StreamFactoryFacade.newFacade(baseDirs);
        sff.setDefaultLevel("info");
        final S2ContainerBuilder diconBuilder = new BrownieXmlS2ContainerBuilder(sff);
        builders.put("xml", diconBuilder);
        builders.put("dicon", diconBuilder);
    }

    private S2ContainerBuilder getBuilder(String ext) {
        final S2ContainerBuilder builder = (S2ContainerBuilder) builders.get(ext);
        return (builder != null) ? builder : getDefaultBuilder(ext);
    }

    private static final Map factories = new HashMap();

    private static BrownieS2ContainerFactory getFactory(String baseDirs) {
        BrownieS2ContainerFactory factory = (BrownieS2ContainerFactory) factories.get(Thread.currentThread());
        if (factory == null) {
            if (StringUtil.isEmpty(baseDirs))
                factory = new BrownieS2ContainerFactory();
            else
                factory = new BrownieS2ContainerFactory(baseDirs);
        }
        factories.put(Thread.currentThread(), factory);
        return factory;
    }

    protected S2Container doCreate(String path) {
        final String ext = ResourceUtil.getExtension(path);
        if (ext == null) {
            throw new ExtensionNotFoundRuntimeException(path);
        }
        S2ContainerBuilder builder = getBuilder(ext);
        return builder.build(path);
    }

    public static S2Container create(String path) {
        return create(path, null);
    }

    public static S2Container create(String path, String baseDirs) {
        final BrownieS2ContainerFactory factory = getFactory(baseDirs);
        return factory.doCreate(path);
    }

}