/*
 * Created on 2004/11/16
 */
package org.asyrinx.brownie.pdf.fop.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

import org.apache.fop.apps.FOPException;
import org.asyrinx.brownie.pdf.fop.FopInvoker;
import org.xml.sax.InputSource;

/**
 * @author takeshi
 */
public abstract class AbstractFopInvoker implements FopInvoker {

    /**
     *  
     */
    public AbstractFopInvoker() {
        super();
    }

    /*
     * (non-Javadoc)
     * 
     * @see jp.co.tecowl.spike.fop2.FopInvoker#execute(java.lang.String,
     *        java.lang.String, java.lang.String)
     */
    public void execute(String sourceFileName, String xslFileName,
            String destFileName) throws FileNotFoundException, FOPException {
        this.execute(new File(sourceFileName), new File(xslFileName), new File(
                destFileName));
    }

    /*
     * (non-Javadoc)
     * 
     * @see jp.co.tecowl.spike.fop2.FopInvoker#execute(java.io.File,
     *        java.io.File, java.io.File)
     */
    public void execute(File source, File xsl, File dest)
            throws FileNotFoundException, FOPException {
        this.execute(new FileInputStream(source), new FileInputStream(xsl),
                new FileOutputStream(dest));
    }

    /*
     * (non-Javadoc)
     * 
     * @see jp.co.tecowl.spike.fop2.FopInvoker#execute(java.io.InputStream,
     *        java.io.InputStream, java.io.OutputStream)
     */
    public void execute(InputStream source, InputStream xsl, OutputStream dest)
            throws FOPException {
        this.execute(new InputSource(source), new InputSource(xsl), dest);
    }

    public abstract void execute(InputSource source, InputSource xsl,
            OutputStream dest) throws FOPException;
}