/*
 * Created on 2004/06/03
 */
package org.asyrinx.brownie.net.socket;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author akima
 */
public class SocketServer implements Runnable {
	public static final String DEFAULT_TERMINATE_MESSAGE = "<<terminate>>";

	/**
	 *  
	 */
	public SocketServer(SocketServerListener listener, int port) {
		this(listener, port, DEFAULT_TERMINATE_MESSAGE);
	}

	/**
	 *  
	 */
	public SocketServer(SocketServerListener listener, int port,
			String terminateMessage) {
		super();
		this.port = port;
		this.listener = listener;
		this.terminateMessage = terminateMessage;
	}

	private final int port;

	private final String terminateMessage;

	private final SocketServerListener listener;

	private final Log log = LogFactory.getLog(this.getClass());

	private boolean runnging = false;

	private ServerSocket serverSocket = null;

	protected void connect() throws IOException {
		if (isConnected())
			return;
		this.serverSocket = new ServerSocket(port);
		log.info("socket connected port " + port);
	}

	protected void disconnect() throws IOException {
		if (!isConnected())
			return;
		log.info("socket disconnected");
		this.serverSocket.close();
		this.serverSocket = null;
	}

	public void stop() {
		runnging = false;
	}

	protected void sendTerminateMessage() {
		final SocketClient client = new SocketClient("localhost", this.port);
		try {
			client.execute(this.terminateMessage);
		} catch (IOException e) {
			log.error("failed to stop socket.");
		}
	}

	public boolean isConnected() {
		return this.serverSocket != null;
	}

	private IOException occurred = null;

	/**
	 * @return Returns the occurred.
	 */
	public IOException getOccurred() {
		return occurred;
	}

	public void executeAsThread() {
		final Thread thread = new Thread(this);
		thread.run();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Runnable#run()
	 */
	public void run() {
		try {
			connect();
			runnging = true;
			try {
				while (runnging) {
					receive();
				}
			} finally {
				disconnect();
			}
		} catch (IOException e) {
			occurred = e;
			if (isConnected()) {
				try {
					disconnect();
				} catch (IOException e1) {
					//ignore intensionally
				}
			}
		}
	}

	protected void receive() throws IOException {
		// NCAg̐ڑ҂܂
		log.info("socket waiting....");
		final Socket socket = serverSocket.accept();
		log.info("socket accepted");
		try {
			final BufferedReader in = new BufferedReader(new InputStreamReader(
					socket.getInputStream()));
			try {
				String line;
				while ((line = in.readLine()) != null) {
					log.info("socket accepted message: '" + line + "'");
					if (line.equals(this.terminateMessage)) {
						runnging = false;
						log.info("accept terminateMessage");
					} else {
						notifyToClient(line);
					}
				}
			} finally {
				in.close();
			}
		} finally {
			socket.close();
			log.info("socket closed");
		}
	}

	protected void notifyToClient(String line) {
		synchronized (listener) {
			listener.receipt(line);
		}
	}

	private static SocketServer server = null;

	public static void main(String[] args) {
		server = new SocketServer(new SocketServerListener() {
			private int count = 0;

			public void receipt(String line) {
				count++;
				System.out.println(count + "reciept: " + line);
				SocketServer.received(line, count);
			}
		}, 5555);
		server.run();
	}

	protected static void received(String line, int count) {
		if (count >= 5)
			server.stop();
	}
}