/*
 * Created on 2004/06/04
 */
package org.asyrinx.brownie.net.socket;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;

/**
 * @author akima
 */
public class SocketClient {
	/**
	 *  
	 */
	public SocketClient() {
		super();
	}

	public SocketClient(String host, int port) {
		super();
		this.host = host;
		this.port = port;
	}

	private Socket socket;

	private String host = null;

	private int port = 5555;

	public void execute(String message) throws IOException {
		connect();
		try {
			send(message);
		} finally {
			disconnect();
		}
	}

	public void connect() throws IOException {
		socket = new Socket(host, port);
	}

	public void disconnect() throws IOException {
		socket.close();
	}

	public boolean isConnected() {
		return socket != null;
	}

	public void send(String message) throws IOException {
		final PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
		try {
			out.println(message);
		} finally {
			out.close();
		}
	}

	/**
	 * @return Returns the host.
	 */
	public String getHost() {
		return host;
	}

	/**
	 * @param host
	 *            The host to set.
	 */
	public void setHost(String host) {
		this.host = host;
	}

	/**
	 * @return Returns the port.
	 */
	public int getPort() {
		return port;
	}

	/**
	 * @param port
	 *            The port to set.
	 */
	public void setPort(int port) {
		this.port = port;
	}

	/**
	 * @return Returns the socket.
	 */
	public Socket getSocket() {
		return socket;
	}
}