/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2003/12/27
 */
package org.asyrinx.brownie.log.log4j.servlet;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.apache.log4j.BasicConfigurator;
import org.asyrinx.brownie.core.io.FileConstants;
import org.asyrinx.brownie.core.io.FileNameUtils;
import org.asyrinx.brownie.servlet.FileNameResolver;

/**
 * @author akima
 */
public class Log4jInitFilter implements Filter {

	/**
	 *  
	 */
	public Log4jInitFilter() {
		super();
	}

	/**
	 * @see javax.servlet.Filter#init(javax.servlet.FilterConfig)
	 */
	public void init(FilterConfig config) throws ServletException {
		initLog4j(config);
	}

	public static final String CONFIG_KEY_LOG4J = "log4j";

	public static final String CONFIG_KEY_FILE_WATCH = "file_watch";

	/**
	 * @param config
	 */
	protected void initLog4j(FilterConfig config) {
		final ServletContext context = config.getServletContext();
		if (context == null)
			throw new RuntimeException(
					"ServletContext which was obtained from FilterConfig is null !!!  why!!!!!!!!!!!!??????????? ");
		final FileNameResolver resolver = new FileNameResolver(context);
		final String configFile = resolver.toRealPath(config
				.getInitParameter(CONFIG_KEY_LOG4J));

		final boolean fileWatch = "true".equalsIgnoreCase(config
				.getInitParameter(CONFIG_KEY_FILE_WATCH));
		if (FileConstants.EXT_XML.equalsIgnoreCase(FileNameUtils
				.getExtension(configFile))) {
			if (fileWatch)
				ServletDOMConfigurator.configureAndWatch(configFile, context);
			else
				ServletDOMConfigurator.configure(configFile, context);
		} else if (FileConstants.EXT_PROPERTIES.equalsIgnoreCase(FileNameUtils
				.getExtension(configFile))) {
			if (fileWatch)
				ServletPropertyConfigurator.configureAndWatch(configFile,
						context);
			else
				ServletPropertyConfigurator.configure(configFile, context);
		} else {
			context.log(BasicConfigurator.class.getName() + "#configure()");
			BasicConfigurator.configure();
		}
	}

	protected final void log(ServletContext context, String message) {
		context.log(this.getClass().getName() + ": " + message);
	}

	/**
	 * @see javax.servlet.Filter#doFilter(javax.servlet.ServletRequest,
	 *      javax.servlet.ServletResponse, javax.servlet.FilterChain)
	 */
	public void doFilter(ServletRequest req, ServletResponse res,
			FilterChain chain) throws IOException, ServletException {
		chain.doFilter(req, res);
	}

	/**
	 * @see javax.servlet.Filter#destroy()
	 */
	public void destroy() {
		//do nothing
	}

}