/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.jdbc.wrapper;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

import org.asyrinx.brownie.core.util.Wrapper;

/**
 * @author Akima
 */
public class StatementWrapper extends Wrapper implements Statement {

	/**
	 * Constructor for StatementWrapper.
	 */
	public StatementWrapper(Statement source) {
		super(source);
		this.source = source;
	}

	private final Statement source;

	/**
	 * @param sql
	 * @throws java.sql.SQLException
	 */
	public void addBatch(String sql) throws SQLException {
		source.addBatch(sql);
	}

	/**
	 * @throws java.sql.SQLException
	 */
	public void cancel() throws SQLException {
		source.cancel();
	}

	/**
	 * @throws java.sql.SQLException
	 */
	public void clearBatch() throws SQLException {
		source.clearBatch();
	}

	/**
	 * @throws java.sql.SQLException
	 */
	public void clearWarnings() throws SQLException {
		source.clearWarnings();
	}

	/**
	 * @throws java.sql.SQLException
	 */
	public void close() throws SQLException {
		source.close();
	}

	/**
	 * @param sql
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public boolean execute(String sql) throws SQLException {
		return source.execute(sql);
	}

	/**
	 * @param sql
	 * @param autoGeneratedKeys
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public boolean execute(String sql, int autoGeneratedKeys)
			throws SQLException {
		return source.execute(sql, autoGeneratedKeys);
	}

	/**
	 * @param sql
	 * @param columnIndexes
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public boolean execute(String sql, int[] columnIndexes) throws SQLException {
		return source.execute(sql, columnIndexes);
	}

	/**
	 * @param sql
	 * @param columnNames
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public boolean execute(String sql, String[] columnNames)
			throws SQLException {
		return source.execute(sql, columnNames);
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public int[] executeBatch() throws SQLException {
		return source.executeBatch();
	}

	/**
	 * @param sql
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public ResultSet executeQuery(String sql) throws SQLException {
		return source.executeQuery(sql);
	}

	/**
	 * @param sql
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public int executeUpdate(String sql) throws SQLException {
		return source.executeUpdate(sql);
	}

	/**
	 * @param sql
	 * @param autoGeneratedKeys
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public int executeUpdate(String sql, int autoGeneratedKeys)
			throws SQLException {
		return source.executeUpdate(sql, autoGeneratedKeys);
	}

	/**
	 * @param sql
	 * @param columnIndexes
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public int executeUpdate(String sql, int[] columnIndexes)
			throws SQLException {
		return source.executeUpdate(sql, columnIndexes);
	}

	/**
	 * @param sql
	 * @param columnNames
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public int executeUpdate(String sql, String[] columnNames)
			throws SQLException {
		return source.executeUpdate(sql, columnNames);
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public Connection getConnection() throws SQLException {
		return source.getConnection();
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public int getFetchDirection() throws SQLException {
		return source.getFetchDirection();
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public int getFetchSize() throws SQLException {
		return source.getFetchSize();
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public ResultSet getGeneratedKeys() throws SQLException {
		return source.getGeneratedKeys();
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public int getMaxFieldSize() throws SQLException {
		return source.getMaxFieldSize();
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public int getMaxRows() throws SQLException {
		return source.getMaxRows();
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public boolean getMoreResults() throws SQLException {
		return source.getMoreResults();
	}

	/**
	 * @param current
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public boolean getMoreResults(int current) throws SQLException {
		return source.getMoreResults(current);
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public int getQueryTimeout() throws SQLException {
		return source.getQueryTimeout();
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public ResultSet getResultSet() throws SQLException {
		return source.getResultSet();
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public int getResultSetConcurrency() throws SQLException {
		return source.getResultSetConcurrency();
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public int getResultSetHoldability() throws SQLException {
		return source.getResultSetHoldability();
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public int getResultSetType() throws SQLException {
		return source.getResultSetType();
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public int getUpdateCount() throws SQLException {
		return source.getUpdateCount();
	}

	/**
	 * @return @throws
	 *         java.sql.SQLException
	 */
	public SQLWarning getWarnings() throws SQLException {
		return source.getWarnings();
	}

	/**
	 * @param name
	 * @throws java.sql.SQLException
	 */
	public void setCursorName(String name) throws SQLException {
		source.setCursorName(name);
	}

	/**
	 * @param enable
	 * @throws java.sql.SQLException
	 */
	public void setEscapeProcessing(boolean enable) throws SQLException {
		source.setEscapeProcessing(enable);
	}

	/**
	 * @param direction
	 * @throws java.sql.SQLException
	 */
	public void setFetchDirection(int direction) throws SQLException {
		source.setFetchDirection(direction);
	}

	/**
	 * @param rows
	 * @throws java.sql.SQLException
	 */
	public void setFetchSize(int rows) throws SQLException {
		source.setFetchSize(rows);
	}

	/**
	 * @param max
	 * @throws java.sql.SQLException
	 */
	public void setMaxFieldSize(int max) throws SQLException {
		source.setMaxFieldSize(max);
	}

	/**
	 * @param max
	 * @throws java.sql.SQLException
	 */
	public void setMaxRows(int max) throws SQLException {
		source.setMaxRows(max);
	}

	/**
	 * @param seconds
	 * @throws java.sql.SQLException
	 */
	public void setQueryTimeout(int seconds) throws SQLException {
		source.setQueryTimeout(seconds);
	}

}