/*
 * Created on 2004/11/15
 */
package org.asyrinx.brownie.core.xml.dom.impl;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

import org.asyrinx.brownie.core.xml.dom.RenderingAttribute;
import org.asyrinx.brownie.core.xml.dom.RenderingDuplicated;
import org.w3c.dom.Element;

/**
 * @author takeshi
 */
public class DomBuilderNode extends AbstractDomBuilder {

    /**
     *  
     */
    public DomBuilderNode() {
        super();
    }

    /**
     * @param renderingDuplicated
     * @param renderingAttribute
     */
    public DomBuilderNode(RenderingDuplicated renderingDuplicated, RenderingAttribute renderingAttribute) {
        super(renderingDuplicated, renderingAttribute);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.xml.dom.AbstractDomBuilder#prepareRoot(org.w3c.dom.Element,
     *      java.lang.Object)
     */
    public void prepareRoot(Element root, Object bean) {
        super.prepareRoot(root, bean);
        this.getRenderingAttribute().render(root, bean);
        this.getRenderingDuplicated().addBean(bean);
    }

    /**
     * @param element
     * @param key
     * @param value
     */
    protected void renderToElement(Element element, final Object key, final Object value) {
        if ((value instanceof String) || (value instanceof Number) || (value instanceof Date)
                || (value instanceof Boolean) || (value instanceof Class)) {
            final Element prop = this.document.createElement(String.valueOf(key));
            element.appendChild(prop);
            final String text = toString(key, value);
            prop.appendChild(this.document.createTextNode(text));
        } else if (value instanceof Collection) {
            final Collection list = (Collection) value;
            for (Iterator i = list.iterator(); i.hasNext();) {
                buildSub(element, key, i.next());
            }
        } else if (value instanceof Object[]) {
            final Object[] objects = (Object[]) value;
            for (int i = 0; i < objects.length; i++) {
                buildSub(element, key, objects[i]);
            }
        } else if (value instanceof Map) {
            buildSub(element, key, value);
        } else {
            buildSub(element, key, value);
        }
    }

    /**
     * @param element
     * @param key
     * @param obj
     */
    private void buildSub(Element element, final Object key, final Object obj) {
        final Element sub = this.document.createElement(String.valueOf(key));
        this.getRenderingAttribute().render(sub, obj);
        element.appendChild(sub);
        if (this.getRenderingDuplicated().addBean(obj))
            this.execute(obj, sub);
    }

}