/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/26 2:35:13
 */
package org.asyrinx.brownie.core.xml.dom;

import org.w3c.dom.Element;

/**
 * @author takeshi
 */
public interface RenderingAttribute {

    void render(Element element, Object bean);

    public static class Composite implements RenderingAttribute {

        public Composite(RenderingAttribute[] wrapped) {
            super();
            this.wrapped = wrapped;
        }

        protected final RenderingAttribute[] wrapped;

        public void render(Element element, Object bean) {
            for (int i = 0; i < this.wrapped.length; i++) {
                this.wrapped[i].render(element, bean);
            }
        }
    }

    public static final RenderingAttribute NULL = new RenderingAttribute() {
        public void render(Element element, Object bean) {
        }
    };

    public static final RenderingAttribute CLASS = new RenderingAttribute() {
        public void render(Element element, Object bean) {
            element.setAttribute("class", String.valueOf(bean.getClass().getName()));
        }
    };

    public static final RenderingAttribute HASH_CODE = new RenderingAttribute() {
        public void render(Element element, Object bean) {
            element.setAttribute("hashCode", String.valueOf(bean.hashCode()));
        }
    };

}