/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.xml.digester;

import javax.xml.parsers.SAXParser;

import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.XMLReader;

/**
 * @author Akima
 * @deprecated use AsyrinxDigester 
 */
public class SettingDigester extends Digester {

    static public final String ATTRIBUTE_CLASS_DEFAULT = "class";

    /**
     * Constructor for SettingDigester.
     */
    public SettingDigester() {
        super();
    }

    /**
     * Constructor for SettingDigester.
     * 
     * @param parser
     */
    public SettingDigester(SAXParser parser) {
        super(parser);
    }

    /**
     * Constructor for SettingDigester.
     * 
     * @param reader
     */
    public SettingDigester(XMLReader reader) {
        super(reader);
    }

    protected final Log log = LogFactory.getLog(this.getClass());

    /**
     * Method addSettingRoot.
     * 
     * @param string
     * @param class
     */
    public void addRoot(String pattern, Class clazz) {
        addRoot(pattern, ATTRIBUTE_CLASS_DEFAULT, clazz);
    }

    /**
     * Method addSettingRoot.
     * 
     * @param string
     * @param class
     */
    public void addRoot(String pattern, String attributeName, Class clazz) {
        addObjectCreate(pattern, attributeName, clazz);
    }

    /**
     * Method addSettingRoot.
     * 
     * @param string
     * @param class
     */
    public void addRoot(String pattern, String className) {
        addRoot(pattern, className, ATTRIBUTE_CLASS_DEFAULT);
    }

    /**
     * Method addSettingRoot.
     * 
     * @param string
     * @param class
     */
    public void addRoot(String pattern, String className, String attributeName) {
        addObjectCreate(pattern, className, attributeName);
    }

    public void addAsProp(String pattern, String propertyName) {
        addRule(pattern, new StackSetPropertyRule(propertyName));
    }

    public void addProp(String pattern, Class clazz, String propertyName, boolean setProperties) {
        addObjectCreate(pattern, ATTRIBUTE_CLASS_DEFAULT, clazz);
        addRule(pattern, new StackSetPropertyRule(propertyName));
        if (setProperties)
            addSetProperties(pattern);
    }

    public void addProp(String pattern, Class clazz, String propertyName) {
        addProp(pattern, clazz, propertyName, true);
    }

    /**
     * Method addNewProperties.
     * 
     * @param string
     * @param class
     * @param string1
     */
    public void addProps(String pattern, Class clazz, String addingMethodName) {
        addObjectCreate(pattern, ATTRIBUTE_CLASS_DEFAULT, clazz);
        addSetProperties(pattern);
        addSetNext(pattern, addingMethodName);
        //addSetProperty(pattern, "property", "value");
        addSetProperties(pattern);
    }

    /**
     * Method addNewProperties.
     * 
     * @param pattern
     * @param clazz
     */
    public void addProps(String pattern, Class clazz) {
        addProps(pattern, clazz, "add");
    }

    /**
     * 
     * @param pattern
     * @param methodName
     * @param paramTypes
     * @param paramName
     * @see org.apache.commons.digester.Digester#addCallMethod(java.lang.String,
     *        java.lang.String, int, java.lang.Class[])
     */
    public void addCallMethod(String pattern, String methodName, Class[] paramTypes, String[] paramName) {
        addCallMethod(pattern, methodName, paramTypes.length, paramTypes);
        for (int i = 0; i < paramName.length; i++) {
            addCallParam(pattern, i, paramName[i]);
        }
    }

    /**
     * 
     * @param patten
     * @param propertyName
     */
    public void addPushProperty(String patten, String propertyName) {
        addRule(patten, new PushPropertyRule(propertyName));
    }

    /**
     * 
     * @param patten
     */
    public void addPop(String patten) {
        addRule(patten, new PopRule());
    }

    /**
     * @param string
     * @param class1
     * @param classes
     * @param strings
     */
    public void addConstructor(String patten, Class clazz, Class[] paramTypes, String[] paramNames) {
        addRule(patten, new ConstructorRule(clazz, paramTypes, paramNames));
    }

    /**
     * @param string
     * @param class1
     * @param classes
     * @param strings
     * @param propertyName
     * @param setProperties
     */
    public void addProp(String pattern, Class clazz, Class[] paramTypes, String[] paramNames, String propertyName) {
        addProp(pattern, clazz, paramTypes, paramNames, propertyName, true);
    }

    /**
     * @param string
     * @param class1
     * @param classes
     * @param strings
     * @param propertyName
     * @param setProperties
     */
    public void addProp(String pattern, Class clazz, Class[] paramTypes, String[] paramNames, String propertyName,
            boolean setProperties) {
        addRule(pattern, new ConstructorRule(clazz, paramTypes, paramNames));
        addRule(pattern, new StackSetPropertyRule(propertyName));
        if (setProperties)
            addSetProperties(pattern);
    }

    /**
     * @param string
     */
    public void addSetToMap(String pattern) {
        addRule(pattern, new SetToMapRule());
    }

    /**
     * @param string
     * @param string2
     */
    public void addBodyToProp(String pattern, String propertyName) {
        addRule(pattern, new SetBodyToPropertyRule(propertyName));
    }
}