/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/08/12 17:17:03
 */
package org.asyrinx.brownie.core.xml.digester;

import java.lang.reflect.InvocationTargetException;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.digester.Rule;
import org.xml.sax.Attributes;

/**
 * @author akima
 */
public class PushPropertyRule extends Rule {

    /**
     * Constructor for StackSetPropertyRule.
     */
    public PushPropertyRule(String propertyName) {
        super();
        this.propertyName = propertyName;
    }

    private final String propertyName;

    /**
     * @see org.apache.commons.digester.Rule#begin(org.xml.sax.Attributes)
     * @deprecated
     */
    public void begin(Attributes attributes) throws Exception {
        execute();
    }

    /**
     * @see org.apache.commons.digester.Rule#begin(java.lang.String,
     *        java.lang.String, org.xml.sax.Attributes)
     */
    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        execute();
    }

    /**
     * @throws NoSuchMethodException
     * @throws InvocationTargetException
     * @throws IllegalAccessException
     */
    private void execute() throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        final Object bean = digester.peek(0);
        final Object pushed = PropertyUtils.getProperty(bean, this.propertyName);
        digester.push(pushed);
    }
}