/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/03/01
 */
package org.asyrinx.brownie.core.sql2;

import java.util.Date;

import org.asyrinx.brownie.core.sql.Operator;

/**
 * @author akima
 */
public class Conditions extends Elements {

	public void accept(Visitor visitor) {
		visitor.visit(this);
	}

	private Operator connection = Operator.AND;

	/**
	 * @return
	 */
	public Operator getConnection() {
		return connection;
	}

	/**
	 * @param operator
	 */
	public void setConnection(Operator operator) {
		connection = operator;
	}

	/**
	 * Qǉ܂B
	 */
	public Conditions addNewCondition() {
		return addNewConditions(this.getConnection());
	}

	/**
	 * Qǉ܂B
	 */
	public Conditions addNewConditions(Operator conn) {
		final Conditions result = new Conditions();
		result.setConnection(conn);
		super.addImpl(result);
		return result;
	}

	/**
	 * ǉ܂B
	 * 
	 * @param condition
	 */
	public Conditions addPlainCondition(String condition) {
		return add(null, condition, Operator.NONE);
	}

	public Conditions add(String field, Object value, Operator operator) {
		final Condition result = new Condition();
		result.setFieldName(field);
		result.setOperator(operator);
		result.setValue(value);
		result.setConditions(this);
		super.addImpl(result);
		return this;
	}

	public Conditions addRange(String field, Object min, Object max) {
		return addRange(field, min, max, true, true);
	}

	public Conditions addRange(String field, Object min, Object max,
			boolean includeMin, boolean includeMax) {
		final Conditions conditions = addNewConditions(Operator.AND);
		if (includeMin)
			conditions.add(field, min, Operator.GREATER_EQUAL);
		else
			conditions.add(field, min, Operator.GREATER_THAN);
		if (includeMax)
			conditions.add(field, max, Operator.LESS_EQUAL);
		else
			conditions.add(field, max, Operator.LESS_THAN);
		return this;
	}

	/**
	 * ȑǉ܂B <br>
	 * w肳ꂽrĺAVONH[gň͂܂܂B
	 * 
	 * @param field
	 *            rtB[h
	 * @param value
	 *            rl
	 * @param operater
	 *            rZq
	 */
	public Conditions add(String field, String value) {
		return add(field, value, Operator.EQUAL);
	}

	/**
	 * ȑǉ܂B <br>
	 * w肳ꂽrĺAVONH[gň͂܂܂B
	 * 
	 * @param field
	 *            rtB[h
	 * @param value
	 *            rl
	 * @param operater
	 *            rZq
	 */
	public Conditions add(String field, String value, Operator operater) {
		return add(field, (Object) value, operater);
	}

	/**
	 * tB[h̐iintjƂēǂƂǉ܂B
	 * 
	 * @param field
	 *            rtB[h
	 * @param value
	 *            rl
	 */
	public Conditions add(String field, int value) {
		return add(field, value, Operator.EQUAL);
	}

	/**
	 * tB[h̐iintjƂĔrǉ܂B
	 * 
	 * @param field
	 *            rtB[h
	 * @param value
	 *            rl
	 * @param operater
	 *            rZq
	 */
	public Conditions add(String field, int value, Operator operater) {
		return add(field, new Integer(value), operater);
	}

	public Conditions addRange(String field, int min, int max,
			boolean includeMin, boolean includeMax) {
		return addRange(field, new Integer(min), new Integer(max), includeMin,
				includeMax);
	}

	/**
	 * tB[h̐ilongjƂēǂƂǉ܂B
	 * 
	 * @param field
	 *            rtB[h
	 * @param value
	 *            rl
	 */
	public Conditions add(String field, long value) {
		return add(field, value, Operator.EQUAL);
	}

	/**
	 * tB[h̐ilongjƂĔrǉ܂B
	 * 
	 * @param field
	 *            rtB[h
	 * @param value
	 *            rl
	 * @param operater
	 *            rZq
	 */
	public Conditions add(String field, long value, Operator operater) {
		return add(field, new Long(value), operater);
	}

	public Conditions addRange(String field, long min, long max,
			boolean includeMin, boolean includeMax) {
		return addRange(field, new Long(min), new Long(max), includeMin,
				includeMax);
	}

	public Conditions add(String field, Date value) {
		return add(field, value, Operator.EQUAL);
	}

	public Conditions add(String field, Date value, Operator operater) {
		return add(field, (Object) value, operater);
	}

	public Conditions addRange(String field, Date beginDate, Date endDate) {
		return addRange(field, beginDate, endDate, true, true);
	}

	public Conditions addRange(String field, Date beginDate, Date endDate,
			boolean includeMin, boolean includeMax) {
		return addRange(field, (Object) beginDate, (Object) endDate,
				includeMin, includeMax);
	}

}