/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.sql;

import java.text.DateFormat;
import java.text.SimpleDateFormat;

/**
 * ISELECT𐶐邽߂̃NXłB <br>
 * IɕύXꍇɂ ISQL𐶐Kv܂A PreparedStatementł͎gpɂꍇłB
 * ̂悤ȏꍇɁÃNXgpĂB <br>
 * 
 * @author Akima
 */
public class DynamicSelect {

	/**
	 * Constructor for DynamicSql.
	 */
	public DynamicSelect() {
		this(new BasicSqlBuilder());
	}

	/**
	 * Constructor for DynamicSql.
	 */
	public DynamicSelect(IBuilder builder) {
		super();
		this.builder = builder;
		this.selectFields = new Fields(builder);
		this.fromTables = new Tables(builder);
		this.whereConditions = new Conditions(builder);
		this.groupByFields = new Fields(builder);
		this.havingConditions = new Conditions(builder);
		this.orderByFields = new Fields(builder);
	}

	protected final IBuilder builder;

	private final Fields selectFields;

	private final Tables fromTables;

	private final Conditions whereConditions;

	private final Fields groupByFields;

	private final Conditions havingConditions;

	private final Fields orderByFields;

	private boolean distinct = false;

	private DateFormat dateFormat = new SimpleDateFormat("yyyy/mm/dd");

	public Conditions newConditions() {
		return new Conditions(this.builder);
	}

	public Fields newFields() {
		return new Fields(this.builder);
	}

	/**
	 * @return
	 */
	public DateFormat getDateFormat() {
		return dateFormat;
	}

	/**
	 * @param format
	 */
	public void setDateFormat(DateFormat format) {
		dateFormat = format;
	}

	/**
	 * SQL𐶐܂B <br>
	 * 
	 * @param buffer
	 *            ꂽSQLێobt@
	 */
	public void build(StringBuffer buffer) {
		builder.build(this, buffer);
	}

	/**
	 * SQL𐶐܂B <br>
	 * 
	 * @return ꂽSQL
	 */
	public String build() {
		StringBuffer dest = new StringBuffer();
		build(dest);
		return dest.toString();
	}

	/**
	 * SẴtB[he[uȂǁAǉĂ̂NA܂B <br>
	 * tB[hNAƂꍇɂ́Ã\bhgpɁA ȉ̂悤ɋLqĂB
	 * 
	 * <pre>
	 * DynamicSql sql = new DynamicSql();
	 * sql.addField(&quot;XXX&quot;);
	 * sql.addFrom(&quot;AAA&quot;);
	 * //EEEEE
	 * sql.getSelectFields.clear(); //tB[h폜
	 * 
	 * </pre>
	 */
	public void clear() {
		selectFields.clear();
		fromTables.clear();
		whereConditions.clear();
		orderByFields.clear();
		groupByFields.clear();
		havingConditions.clear();
		distinct = false;
	}

	/**
	 * distinctSQL𐶐邩ǂ\tOłB
	 * 
	 * @return
	 */
	public boolean isDistinct() {
		return distinct;
	}

	/**
	 * distinctSQL𐶐邩ǂwł܂B
	 * 
	 * @param b
	 */
	public void setDistinct(boolean b) {
		distinct = b;
	}

	/**
	 * @return
	 */
	public Tables getFromTables() {
		return fromTables;
	}

	/**
	 * @return
	 */
	public Fields getGroupByFields() {
		return groupByFields;
	}

	/**
	 * @return
	 */
	public Conditions getHavingConditions() {
		return havingConditions;
	}

	/**
	 * @return
	 */
	public Fields getOrderByFields() {
		return orderByFields;
	}

	/**
	 * @return
	 */
	public Fields getSelectFields() {
		return selectFields;
	}

	/**
	 * @return
	 */
	public Conditions getWhereConditions() {
		return whereConditions;
	}

}