/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/20 0:09:31
 */
package org.asyrinx.brownie.core.query.model;

/**
 * @author takeshi
 */
public class FieldAlias {

    /**
     * @param field
     */
    public FieldAlias(Field field) {
        this(field, field.getAliasName());
    }

    /**
     * @param field
     * @param name
     */
    public FieldAlias(Field field, String name) {
        this(field.getTable(), field, name);
    }

    /**
     * @param owner
     * @param field
     * @param name
     */
    public FieldAlias(Table table, Field field, String name) {
        this(table.alias(), field, name);
    }

    /**
     * @param owner
     * @param field
     * @param name
     */
    public FieldAlias(TableAlias owner, Field field, String name) {
        super();
        this.field = field;
        this.name = name;
        this.owner = owner;
    }

    private final Field field;

    private final TableAlias owner;

    /**
     * @return Returns the field.
     */
    public Field getField() {
        return field;
    }

    private String name = null;

    /**
     * @return Returns the name.
     */
    public String getName() {
        return name;
    }

    /**
     * @param name
     *            The name to set.
     */
    public void setName(String name) {
        this.name = name;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.query.IField#getParent()
     */
    public Table getTable() {
        return this.field.getTable();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.query.IField#getType()
     */
    public Class getType() {
        return this.field.getType();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.query.IField#getFormat()
     */
    public String getFormat() {
        return this.field.getFormat();
    }

    /**
     * @return Returns the owner.
     */
    public TableAlias getOwnerAlias() {
        return owner;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.query.model.IField#getOwner()
     */
    public TableAlias getOwner() {
        return getOwnerAlias();
    }
}