/*
 * joey-rt and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/19 17:04:18
 */
package org.asyrinx.brownie.core.query.exp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.brownie.core.query.model.FieldAlias;

/**
 * @author takeshi
 */
public class CompositeExpression implements ICompositeExpression {

    /**
     *  
     */
    public CompositeExpression() {
        super();
    }

    /**
     *  
     */
    public CompositeExpression(String operator) {
        super();
        this.operator = operator;
    }

    private String operator;

    /**
     * @return Returns the operator.
     */
    public String getOperator() {
        return operator;
    }

    protected final List children = new ArrayList();

    /**
     * @param operator
     *            The operator to set.
     */
    public void setOperator(String operator) {
        this.operator = operator;
    }

    /**
     * @param o
     * @return
     */
    public CompositeExpression add(IExpression expression) {
        children.add(expression);
        return this;
    }

    /**
     * 
     * @param fieldName
     * @param value
     * @return
     */
    public CompositeExpression addField(String fieldName, Object value) {
        final IExpression result = new ObjectExpression(fieldName, IExpression.EQUAL, value);
        return this.add(result);
    }

    /**
     * 
     * @param fieldName
     * @param operator
     * @param value
     * @return
     */
    public IExpression addField(String fieldName, String operator, Object value) {
        final IExpression result = new ObjectExpression(fieldName, operator, value);
        return this.add(result);
    }

    /**
     * @param field
     * @param value
     * @return
     */
    public IExpression addField(FieldAlias field, Object value) {
        return this.addField(field, IExpression.EQUAL, value);
    }

    /**
     * @param field
     * @param operator
     * @param value
     * @return
     */
    public IExpression addField(FieldAlias field, String operator, Object value) {
        final FieldAlias alias = field;
        return this.add(new FieldExpression(alias, operator, value));
    }

    /**
     * @param left
     * @param right
     * @return
     */
    public IExpression addCompare(FieldAlias left, FieldAlias right) {
        return this.addCompare(left, right, IExpression.EQUAL);
    }

    /**
     * @param left
     * @param right
     * @param operator
     * @return
     */
    public IExpression addCompare(FieldAlias left, FieldAlias right, String operator) {
        final FieldAlias leftAlias = left;
        final FieldAlias rightAlias = right;
        return this.add(new FieldCompare(leftAlias, rightAlias, operator));
    }

    /**
     *  
     */
    public CompositeExpression addCompo(String operator) {
        final CompositeExpression result = new CompositeExpression(operator);
        this.add(result);
        return result;
    }

    /**
     *  
     */
    public void clear() {
        children.clear();
    }

    /**
     * @param o
     * @return
     */
    public boolean contains(IExpression o) {
        return children.contains(o);
    }

    /**
     * @param index
     * @return
     */
    public IExpression get(int index) {
        return (IExpression) children.get(index);
    }

    /**
     * @param o
     * @return
     */
    public int indexOf(IExpression o) {
        return children.indexOf(o);
    }

    /**
     * @return
     */
    public boolean isEmpty() {
        return children.isEmpty();
    }

    /**
     * @return
     */
    public Iterator iterator() {
        return children.iterator();
    }

    /**
     * @param o
     * @return
     */
    public boolean remove(IExpression o) {
        return children.remove(o);
    }

    /**
     * @return
     */
    public int size() {
        return children.size();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.query.ICompositeExpression#toArray()
     */
    public IExpression[] toArray() {
        return (IExpression[]) this.children.toArray();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof ICompositeExpression))
            return false;
        final ICompositeExpression other = (ICompositeExpression) obj;
        new EqualsBuilder().append(this.getOperator(), other.getOperator()).append(this.toArray(), other.toArray())
                .isEquals();
        return super.equals(obj);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    public int hashCode() {
        return new HashCodeBuilder().append(this.getOperator()).append(this.toArray()).toHashCode();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return "(" + StringUtils.join(this.iterator(), ")" + this.getOperator() + "(") + ")";
    }

}