/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/20 13:37:35
 */
package org.asyrinx.brownie.core.query;

import java.util.Iterator;

import org.asyrinx.brownie.core.query.exp.CompositeExpression;
import org.asyrinx.brownie.core.query.exp.FieldCompare;
import org.asyrinx.brownie.core.query.exp.FieldExpression;
import org.asyrinx.brownie.core.query.exp.IExpression;
import org.asyrinx.brownie.core.query.exp.IFieldCompare;
import org.asyrinx.brownie.core.query.exp.IFieldValuedExpression;
import org.asyrinx.brownie.core.query.model.FieldAlias;
import org.asyrinx.brownie.core.query.model.FieldAliasList;
import org.asyrinx.brownie.core.query.model.TableAlias;
import org.asyrinx.brownie.core.query.model.TableAliasList;

/**
 * @author takeshi
 */
public class Select implements Cloneable {

    /**
     *  
     */
    public Select() {
        super();
    }

    protected void addFrom(TableAlias tableAlias) {
        if (this.getFroms().indexOf(tableAlias) > -1)
            return;
        this.getFroms().add(tableAlias);
    }

    private final FieldAliasList fields = new SelectFieldAliasList(this);

    private final TableAliasList froms = new TableAliasList();

    private final CompositeExpression where = new SelectComposite(this, IExpression.AND);

    private final FieldAliasList groupBys = new SelectFieldAliasList(this);

    private final CompositeExpression havings = new SelectComposite(this, IExpression.AND);

    private final FieldAliasList orderBys = new SelectFieldAliasList(this);

    /**
     * @return Returns the fields.
     */
    public FieldAliasList getFields() {
        return fields;
    }

    /**
     * @return Returns the froms.
     */
    public TableAliasList getFroms() {
        return froms;
    }

    /**
     * @return Returns the where.
     */
    public CompositeExpression getWhere() {
        return where;
    }

    /**
     * @return Returns the groupBys.
     */
    public FieldAliasList getGroupBys() {
        return groupBys;
    }

    /**
     * @return Returns the havings.
     */
    public CompositeExpression getHavings() {
        return havings;
    }

    /**
     * @return Returns the orderBys.
     */
    public FieldAliasList getOrderBys() {
        return orderBys;
    }

    public void prepareTableAlias() {
        for (Iterator i = getFields().iterator(); i.hasNext();)
            addTableAlias((FieldAlias) i.next());
        prepareTableAliasForExpression(this.getWhere());
        for (Iterator i = getGroupBys().iterator(); i.hasNext();)
            addTableAlias((FieldAlias) i.next());
        prepareTableAliasForExpression(this.getHavings());
        for (Iterator i = getOrderBys().iterator(); i.hasNext();)
            addTableAlias((FieldAlias) i.next());
    }

    private void prepareTableAliasForExpression(IExpression expression) {
        if (expression instanceof CompositeExpression) {
            final CompositeExpression compo = (CompositeExpression) expression;
            for (Iterator i = compo.iterator(); i.hasNext();)
                prepareTableAliasForExpression((IExpression) i.next());
        } else if (expression instanceof FieldExpression) {
            final FieldExpression fieldExpression = (FieldExpression) expression;
            addTableAlias(fieldExpression.getField());
        } else if (expression instanceof FieldCompare) {
            final FieldCompare fieldCompare = (FieldCompare) expression;
            addTableAlias(fieldCompare.getLeft());
            addTableAlias(fieldCompare.getRight());
        }
    }

    private void addTableAlias(FieldAlias fieldAlias) {
        if (!this.getFroms().contains(fieldAlias.getOwner()))
            this.getFroms().add(fieldAlias.getOwner());
    }

    class SelectFieldAliasList extends FieldAliasList {
        private final Select select;

        public SelectFieldAliasList(Select select) {
            super();
            this.select = select;
        }

        public boolean add(FieldAlias alias) {
            this.select.addFrom(alias.getOwnerAlias());
            return super.add(alias);
        }
    }

    class SelectComposite extends CompositeExpression {
        private final Select select;

        public SelectComposite(Select select, String operator) {
            super(operator);
            this.select = select;
        }

        private void addTableAlias(FieldAlias field) {
            this.select.addFrom(field.getOwnerAlias());
        }

        public CompositeExpression add(IExpression expression) {
            if (expression instanceof IFieldValuedExpression) {
                final IFieldValuedExpression fieldExpression = (IFieldValuedExpression) expression;
                addTableAlias(fieldExpression.getField());
            } else if (expression instanceof IFieldCompare) {
                final IFieldCompare fieldCompare = (IFieldCompare) expression;
                addTableAlias(fieldCompare.getLeft());
                addTableAlias(fieldCompare.getRight());
            }
            return super.add(expression);
        }

        public CompositeExpression addCompo(String operator) {
            final SelectComposite result = new SelectComposite(this.select, operator);
            this.add(result);
            return result;
        }

    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#clone()
     */
    public Object clone() throws CloneNotSupportedException {

        return super.clone();
    }

}