/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.log;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * MeasureLogC^tF[X̎łB reset/donesꂽ珈ԂvZA
 * o͐ƂĂĂꂽLoggerɑ΂Ď(~b)ƃbZ[Wo͂܂B <br>
 * o͐w肳Ȃꍇ͏ɐ܂B
 * 
 * @author Akima
 */
public class MeasureLogImpl implements MeasureLog {

	/**
	 * Constructor for MeasureLogImpl.
	 */
	public MeasureLogImpl(String caption) {
		this(caption, null);
	}

	/**
	 * Constructor for MeasureLogImpl.
	 */
	public MeasureLogImpl(String caption, Log log) {
		this(caption, log, (LogLevel) null);
	}

	/**
	 * Constructor for MeasureLogImpl.
	 */
	public MeasureLogImpl(String caption, Log log, String level) {
		this(caption, log, LogLevel.findByName(level));
	}

	/**
	 * Constructor for MeasureLogImpl.
	 */
	public MeasureLogImpl(String caption, Log log, LogLevel level) {
		super();
		this.caption = caption;
		if (log == null)
			log = LogFactory.getLog(this.getClass());
		if (level == null)
			level = LogLevel.DEBUG;
		this.level = level;
		this.log = log;
	}

	private final Log log;

	private final LogLevel level;

	private final String caption;

	private long startedTime = 0;

	/**
	 * @see org.asyrinx.log.MeasureLog#begin()
	 */
	public void reset() {
		startedTime = System.currentTimeMillis();
	}

	/**
	 * @see org.asyrinx.log.MeasureLog#end()
	 */
	public void done(String message) {
		final StringBuffer msg = new StringBuffer();
		msg.append("[measure");
		msg.append(":");
		msg.append(caption);
		msg.append("] ");
		msg.append(message);
		msg.append(" -- ");
		msg.append(String.valueOf(System.currentTimeMillis() - startedTime));
		level.write(log, msg.toString());
	}

}