/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/03/01
 */
package org.asyrinx.brownie.core.lang.enum;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.enum.Enum;
import org.apache.commons.lang.enum.EnumUtils;

/**
 * @author akima
 */
public class EnumSet {

	/**
	 *  
	 */
	public EnumSet(Class enumClass) {
		super();
		this.enumClass = enumClass;
		this.entries = createEntries();
	}

	protected final Class enumClass;

	protected final List entries;

	protected List createEntries() {
		final List enums = EnumUtils.getEnumList(this.enumClass);
		final List result = new ArrayList(enums.size());
		final Iterator iterator = enums.iterator();
		while (iterator.hasNext()) {
			final Enum enum = (ValuedEnum) iterator.next();
			result.add(toEntry(enum));
		}
		return Collections.unmodifiableList(result);
	}

	protected EnumSetEntry toEntry(Enum enum) {
		return new EnumSetEntry(enum);
	}

	public Set getSelectedEnums() {
		return toEnumSet(new SelectedPredicate(true));
	}

	public Set getUnselectedEnums() {
		return toEnumSet(new SelectedPredicate(false));
	}

	protected static class SelectedPredicate implements Predicate {
		public SelectedPredicate(boolean selected) {
			this.selected = selected;
		}

		final boolean selected;

		public boolean evaluate(Object input) {
			final EnumSetEntry entry = (EnumSetEntry) input;
			return entry.isSelected() == selected;
		}
	}

	protected final Set toEnumSet(Predicate predicate) {
		final Set result = new HashSet();
		final Iterator iterator = this.iterator();
		while (iterator.hasNext()) {
			final EnumSetEntry entry = (EnumSetEntry) iterator.next();
			if (predicate.evaluate(entry))
				result.add(entry.getEnum());
		}
		return result;
	}

	protected final EnumSetEntry findEntry(Predicate predicate) {
		final Iterator iterator = this.iterator();
		while (iterator.hasNext()) {
			final EnumSetEntry entry = (EnumSetEntry) iterator.next();
			if (predicate.evaluate(entry))
				return entry;
		}
		return null;
	}

	public EnumSetEntry getEntryByName(final String enumName) {
		return findEntry(new Predicate() {
			public boolean evaluate(Object input) {
				final EnumSetEntry entry = (EnumSetEntry) input;
				return enumName.equals(entry.getName());
			}
		});
	}

	public EnumSetEntry getEntry(final Enum enum) {
		return findEntry(new Predicate() {
			public boolean evaluate(Object input) {
				final EnumSetEntry entry = (EnumSetEntry) input;
				return enum == entry.getEnum();
			}
		});
	}

	public int size() {
		return entries.size();
	}

	public Iterator iterator() {
		return entries.iterator();
	}

}