/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.lang;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

import org.apache.commons.lang.ObjectUtils;

/**
 * Ɋւ鑀sNXłB
 * 
 * @author Akima
 */
public final class StringUtils extends org.apache.commons.lang.StringUtils {

    /**
     * StringBuffer̕u܂B
     * 
     * @param buffer
     *               u镶
     * @param pattern
     *               
     * @param newPattern
     *               u
     */
    public static void replace(StringBuffer buffer, String pattern, String newPattern) {
        if (StringUtils.equals(pattern, newPattern))
            return;
        int patternLength = pattern.length();
        int idx = buffer.toString().indexOf(pattern);
        while (idx > -1) {
            buffer.replace(idx, idx + patternLength, newPattern);
            idx = buffer.toString().indexOf(pattern, idx + newPattern.length());
        }
    }

    /**
     * StringBuffer̕u܂B
     * 
     * @param buffer
     *               u镶
     * @param pattern
     *               
     * @param newPattern
     *               u
     */
    public static void replace(StringBuffer buffer, char oldChar, char newChar) {
        int idx = buffer.toString().indexOf(oldChar);
        String newString = newChar + "";
        while (idx > -1) {
            buffer.replace(idx, idx + 1, newString);
            idx = buffer.toString().indexOf(oldChar, idx + 1);
        }
    }

    /** Ƃ݂Ȃׂ̂ */
    private static final String NUMERIC_CHARS = ".-0123456789D|OPQRSTUVWX";

    /**
     * ̒̐Ƃ݂Ȃ镶(pESp0`9A.-)ȊO폜ĕԂ܂B
     * 
     * @param value
     *               
     * @return ꂽ̕
     */
    public static String deleteNotNumeric(Object value) {
        if (value == null)
            return null;
        final StringBuffer result = new StringBuffer();
        final String str = String.valueOf(value);
        for (int i = 0; i < str.length(); i++) {
            char c = str.charAt(i);
            if (NUMERIC_CHARS.indexOf(c) > -1) {
                result.append(c);
            }
        }
        return result.toString();
    }

    /** ׂ */
    private static final String NUMBER_CHARS = "0123456789OPQRSTUVWX";

    /**
     * ǂ𔻒fB
     * 
     * @param c
     */
    public static boolean isNumeric(char c) {
        return NUMBER_CHARS.indexOf(c) > -1;
    }

    /**
     * ܂ނǂ𔻒fB
     * 
     * @param string
     */
    public static boolean hasNumeric(String string) {
        if (isEmpty(string))
            return false;
        for (int i = 0; i < string.length(); i++) {
            if (NUMBER_CHARS.indexOf(string.charAt(i)) > -1)
                return true;
        }
        return false;
    }

    /**
     * ݂̂ō\Ă邩ǂ𔻒fB
     * 
     * @param string
     */
    public static boolean isNumericOnly(String string) {
        if (isEmpty(string))
            return false;
        for (int i = 0; i < string.length(); i++) {
            if (NUMBER_CHARS.indexOf(string.charAt(i)) < 0)
                return false;
        }
        return true;
    }

    /**
     * ̒̐(pASp0`9)ȊO폜ĕԂ܂B
     * 
     * @param value
     *               
     * @return ꂽ̕
     */
    public static String deleteNotNumber(String value) {
        if (value == null)
            return null;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < value.length(); i++) {
            char c = value.charAt(i);
            if (NUMBER_CHARS.indexOf(c) > -1) {
                result.append(c);
            }
        }
        return result.toString();
    }

    public static final String REPLACE_WORD_HEADER = "${";

    public static final String REPLACE_WORD_FOOTER = "}";

    /**
     * ϐu郁\bhB ϐ '${'  '}' ŋ܂ꂽƂĕ\B
     * 
     * @param source
     *               
     * @param properties
     *               u镶ƂȂ肦镶Q
     * @return String ϐɒuƂ̕
     */
    public static String replaceWithProperties(String source, Properties properties) {
        return replaceWithProperties(source, properties, REPLACE_WORD_HEADER, REPLACE_WORD_FOOTER);
    }

    /**
     * ϐu郁\bhB
     * 
     * @param source
     *               
     * @param delimBegin
     *               Jn̋؂蕶
     * @param delimEnd
     *               I̋؂蕶
     * @return ϐɒuƂ̕
     */
    public static String replaceWithProperties(String source, Properties properties, String delimBegin, String delimEnd) {
        if (source == null)
            return null;
        if (isEmpty(delimBegin) || isEmpty(delimEnd))
            throw new UnsupportedOperationException("delimeter must be not null: '" + delimBegin + "' and '" + delimEnd
                    + "'");
        String key = extractString(source, delimBegin, delimEnd);
        while (key != null) {
            source = replace(source, delimBegin + key + delimEnd, properties.getProperty(key, ""));
            key = extractString(source, delimBegin, delimEnd);
        }
        return source;
    }

    /**
     * Ŏw肳ꂽ؂蕶ŋ܂ꂽ𒊏o
     * 
     * @param source
     *               
     * @param delimBegin
     *               Jn̋؂蕶
     * @param delimEnd
     *               I̋؂蕶
     * @return oꂽ
     */
    public static String extractString(String source, String delimBegin, String delimEnd) {
        return extractString(source, delimBegin, delimEnd, 0);
    }

    /**
     * Ŏw肳ꂽ؂蕶ŋ܂ꂽ𒊏o
     * 
     * @param source
     *               
     * @param delimBegin
     *               Jn̋؂蕶
     * @param delimEnd
     *               I̋؂蕶
     * @param fromIndex
     *               Jn镶̈ʒu
     * @return oꂽ
     */
    public static String extractString(String source, String delimBegin, String delimEnd, int fromIndex) {
        int idxBegin = source.indexOf(delimBegin, fromIndex);
        if (idxBegin < 0)
            return null;
        int idxEnd = source.indexOf(delimEnd, idxBegin + 1);
        if (idxEnd < 0)
            return null;
        return source.substring(idxBegin + delimBegin.length(), idxEnd);
    }

    /**
     * Ŏw肳ꂽ؂蕶ŋ܂ꂽ𒊏oA ListɒǉB
     * 
     * @param source
     *               
     * @param dest
     *               Xg
     * @param delim
     *               ؂蕶
     */
    public static void extractStrings(String source, List dest, char delim) {
        extractStrings(source, dest, delim, delim, 0);
    }

    /**
     * Ŏw肳ꂽ؂蕶ŋ܂ꂽ𒊏oA ListɒǉB
     * 
     * @param source
     *               
     * @param dest
     *               Xg
     * @param delimBegin
     *               Jn̋؂蕶
     * @param delimEnd
     *               I̋؂蕶
     */
    public static void extractStrings(String source, List dest, char delimBegin, char delimEnd) {
        extractStrings(source, dest, delimBegin, delimEnd, 0);
    }

    /**
     * Ŏw肳ꂽ؂蕶ŋ܂ꂽ𒊏oA ListɒǉB
     * 
     * @param source
     *               
     * @param dest
     *               Xg
     * @param delimBegin
     *               Jn̋؂蕶
     * @param delimEnd
     *               I̋؂蕶
     * @param fromIndex
     *               Jn镶̈ʒu
     */
    public static void extractStrings(String source, List dest, char delimBegin, char delimEnd, int fromIndex) {
        int idxBegin = source.indexOf(delimBegin, fromIndex);
        while (idxBegin > -1) {
            int idxEnd = source.indexOf(delimEnd, idxBegin + 1);
            if (idxEnd < 0)
                return;
            dest.add(source.substring(idxBegin + 1, idxEnd));
            idxBegin = source.indexOf(delimBegin, idxEnd + 1);
        }
    }

    /**
     * p[^̒lnullȂ΋󕶎ɁAȊO͂̂܂ܕԂ܂B
     * 
     * @param value
     *               
     * @return String u̕
     */
    public static String defaultString(Object value) {
        return defaultString(value, EMPTY);
    }

    /**
     * p[^̒lnullȂ΋󕶎ɁAȊO <BR>
     * trimtruȅꍇtrimāAtrimfalsȅꍇ͂̂܂ܕԂ܂B
     * 
     * @param value
     *               
     * @return String u̕
     */
    public static String defaultString(Object value, String defaultValue) {
        return (value == null) ? defaultValue : value.toString();
    }

    /**
     * z̕nullTrimȂȂ܂B z񎩑̂null̂Ƃ̓kԂ܂B
     * 
     * @param values
     *               񂪊i[ꂽ
     * @param ȂƂ̕
     */
    public static String[] defaultStrings(Object[] values) {
        return defaultStrings(values, EMPTY);
    }

    /**
     * z̕nullTrimȂȂ܂B
     * <P>
     * z񎩑̂null̂Ƃ̓kԂ܂B
     * 
     * @param values
     *               񂪊i[ꂽ
     */
    public static String[] defaultStrings(Object[] values, String defaultValue) {
        if (values == null)
            return null;
        final String[] result = new String[values.length];
        for (int i = 0; i < result.length; i++) {
            result[i] = defaultString(values[i], defaultValue);
        }
        return result;
    }

    /**
     * String^ǂrB ǂ炩nullłr\BƂnull̏ꍇtrue
     * 
     * @param target1
     *               
     * @param target2
     *               
     * @return boolean ǂB
     */
    public static boolean compare(String target1, String target2) {
        return ObjectUtils.equals(target1, target2);
    }

    /**
     * w肳ꂽ؂蕶ɂĕĕԂ܂B
     * 
     * @param value
     *               
     * @param delimiters
     *               ؂蕶
     * @return ؂ꂽ񂪊i[ꂽList
     */
    public static List parseToList(String value, String delimiters) {
        List result = new Vector();
        StringTokenizer tokenizer = new StringTokenizer(value, delimiters, false);
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        return result;
    }

    /**
     * DOCUMENT ME!
     * 
     * @param dest
     *               DOCUMENT ME!
     * @param str
     *               DOCUMENT ME!
     * @param delim
     *               DOCUMENT ME!
     */
    public static void tokenize(List dest, String str, String delim) {
        if (dest == null)
            return;
        if (StringUtils.isEmpty(str))
            return;
        final StringBuffer buf = new StringBuffer(str);
        //
        int idx = buf.indexOf(delim);
        if (idx < 0) {
            dest.add(str);
            return;
        }
        while (idx > -1) {
            dest.add(buf.substring(0, idx));
            buf.delete(0, idx + delim.length());
            idx = buf.toString().indexOf(delim);
        }
        dest.add(buf.toString());
    }

    /**
     * Method tokenize.
     * 
     * @param str
     * @param delim
     * @return Object[]
     */
    public static String[] tokenizeToArray(String str, String delim) {
        if (str == null)
            return null;
        ArrayList resultList = new ArrayList();
        tokenize(resultList, str, delim);
        if (resultList.size() < 1)
            return new String[0];
        String[] result = new String[resultList.size()];
        for (int i = 0; i < resultList.size(); i++)
            result[i] = (String) resultList.get(i);
        return result;
    }

    /**
     * DOCUMENT ME!
     * 
     * @param dest
     *               DOCUMENT ME!
     * @param str
     *               DOCUMENT ME!
     * @param delim
     *               DOCUMENT ME!
     */
    public static List tokenize(String str, String delim) {
        final List result = new ArrayList();
        tokenize(result, str, delim);
        return result;
    }

    /**
     * source̕z̒Ɉvalueŕ\镶݂ꍇA CfbNXԂ܂B݂Ȃꍇɂ -1 Ԃ܂B
     */
    public static int indexOf(char[] source, char value) {
        if (source == null)
            return -1;
        for (int i = 0; i < source.length; i++) {
            if (source[i] == value)
                return i;
        }
        return -1;
    }

    /**
     * schars̒̂ǂꂩł܂łtrueԂ܂B ǂ܂łȂƂɂfalseԂ܂B
     */
    public static boolean containAnyChar(String s, char[] chars) {
        if (s == null)
            return false;
        if (chars == null)
            return false;
        for (int i = 0; i < chars.length; i++) {
            int idx = s.indexOf(chars[i]);
            if (idx > -1)
                return true;
        }
        return false;
    }

    static protected final char QUOTE_SINGLE = '\'';

    static protected final char QUOTE_DOUBLE = '"';

    public static final char QUOTE_SINGLE_ZENKAKU_BEGIN = 'e';

    public static final char QUOTE_SINGLE_ZENKAKU_END = 'f';

    public static final char QUOTE_DOUBLE_ZENKAKU_BEGIN = 'g';

    public static final char QUOTE_DOUBLE_ZENKAKU_END = 'h';

    public static final char[] QUOTE_SINGLES = new char[] { QUOTE_SINGLE, QUOTE_SINGLE_ZENKAKU_BEGIN,
            QUOTE_SINGLE_ZENKAKU_END };

    public static final char[] QUOTE_DOUBLES = new char[] { QUOTE_DOUBLE, QUOTE_DOUBLE_ZENKAKU_BEGIN,
            QUOTE_DOUBLE_ZENKAKU_END };

    /**
     * 񒆂Ɉp݂ꍇɈpd܂B <br>
     * example: <br>
     * quotes == {'\'', 'e', 'f'} (pASp(n)ASp(I)̃VONI[e[V) ̏ꍇ <br>
     * [nullTrim == false] (null) -> (null) //nullϊΏۊOƂ܂B <br>
     * [nullTrim == true] (null) -> "" //null̓kƓlɕϊ܂B <br>"" -> ""
     * //k͕ϊΏۂłB <br>
     * "aaaa" -> "aaaa" //Oquotet܂B <br>
     * "aa'aa" -> "aa''aa" //OquotetA񒆂quoteQɂȂ܂B <br>
     * "aa\"aa" -> "aa\"aa" //_uNI[g͂̕ƂĈ܂B <br>
     * "aa'\"aa" -> "aa''\"aa" //_uNI[g͂̕ƂĈA <br>
     * "aa''a'a" -> "aa''''a''a" //quote݂ĂSĕϊ܂B <br>
     * "aa'faea" -> "aa''ffaeea" //quotew肳ĂĂAꂼɓd܂B <br>
     */
    public static String duplicateQuote(String value, char[] quotes, boolean nullTrim) {
        if (nullTrim)
            value = defaultString(value);
        if (value == null)
            return null;
        if (!containAnyChar(value, quotes))
            return value;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < value.length(); i++) {
            char c = value.charAt(i);
            result.append(c);
            if (indexOf(quotes, c) > -1)
                result.append(c);
        }
        return result.toString();
    }

    /**
     * value̒̈pdĕԂ܂BSQL̂߂Ɏgp܂B
     * <P>
     * quotesɂ͈ȉ̂ꂩw肵ĉB <BR>
     * QUOTE_SINGLESFpESp̃VONH[e[V <BR>
     * QUOTE_DOUBLESFpESp̃_uNH[e[V <br>
     * 
     * @param value
     * @param quotes
     * @return String
     */
    public static String duplicateQuote(String value, char[] quotes) {
        return duplicateQuote(value, quotes, true);
    }

    /**
     * 񒆂Ɉp݂ꍇɈpd܂B
     * 
     * example: quote == '\''(p̃VONI[e[V) ̏ꍇ [nullTrim == false] (null) ->
     * (null) //nullϊΏۊOƂ܂B [nullTrim == true] (null) -> ""
     * //null̓kƓlɕϊ܂B "" -> "" //k͕ϊΏۂłB "aaaa" -> "aaaa"
     * //Oquotet܂B "aa'aa" -> "aa''aa"
     * //OquotetA񒆂quoteQɂȂ܂B "aa\"aa" -> "aa\"aa"
     * //_uNI[g͂̕ƂĈ܂B "aa'\"aa" -> "aa''\"aa" //_uNI[g͂̕ƂĈA
     * "aa''a'a" -> "aa''''a''a" //quote݂ĂSĕϊ܂B
     *  
     */
    public static String duplicateQuote(String value, char quote, boolean nullTrim) {
        return duplicateQuote(value, new char[] { quote }, nullTrim);
    }

    public static String duplicateQuote(String value, char quote) {
        return duplicateQuote(value, quote, true);
    }

    /**
     * 񒆂Ɉp݂ꍇɈpd܂B <br>
     * example: <br>
     * quote == '\'' ̏ꍇ <br>
     * [nullTrim == false] (null) -> (null) //nullϊΏۊOƂ܂B <br>
     * [nullTrim == true] (null) -> "" //null̓kƓlɕϊ܂B <br>"" -> ""
     * //k͕ϊΏۂłB <br>
     * "aaaa" -> "'aaaa'" //Oquotet܂B <br>
     * "aa'aa" -> "'aa''aa'" //OquotetA񒆂quoteQɂȂ܂B <br>
     * "aa\"aa" -> "'aa\"aa'" //_uNI[g͂̕ƂĈ܂B <br>
     * "aa'\"aa" -> "'aa''\"aa'" //_uNI[g͂̕ƂĈA <br>
     * "aa''a'a" -> "'aa''''a''a'" //quote݂ĂSĕϊ܂B <br>
     */
    public static String toQuoted(String value, char quote, boolean nullTrim) {
        String result = duplicateQuote(value, quote, nullTrim);
        if (!nullTrim && (result == null))
            return null;
        else
            return addQuote(result, quote);
    }

    /**
     * ɈquoteŎw肳ꂽpOɕt܂B <br>
     * A񒆂Ɉp݂ꍇɂ͈pd܂B <br>
     * 
     * ڂ͈ȉ̃\bhQƂĂB <br>
     * 
     * @see toQuoted(String value, char quote, boolean nullTrim)
     */
    public static String toQuoted(String value, char quote) {
        return toQuoted(value, quote, true);
    }

    private static String addQuote(String value, char quote) {
        return quote + defaultString(value) + quote;
    }

    /**
     * ̑OɎw肳ꂽw肳ꂽoCg܂ŋl߂܂B <br>
     * (w肳ꂽoCg-̃oCg)l߂镶̃oCgŊ؂邱ƂOłB <br>
     * ̃oCgw肳ꂽoCgȏ̏ꍇ͂̂܂ܕԂ܂B <br>
     * 
     * @param value
     *               Ƃ̕
     * @param pad
     *               l߂镶
     * @param length
     *               w肳ꂽoCg
     * @return l߂Ԃ̕
     */
    public static String padHead(String value, String pad, int length) {

        if (value.getBytes().length >= length) {
            return value;
        }

        int addNum = (length - value.getBytes().length) / pad.getBytes().length;

        StringBuffer buffer = new StringBuffer(value);

        for (int index = 0; index < addNum; index++) {
            buffer.insert(0, pad);
        }
        return buffer.toString();
    }

    /**
     * ̌Ɏw肳ꂽw肳ꂽoCg܂ŋl߂܂B <br>
     * (w肳ꂽoCg-̃oCg)l߂镶̃oCgŊ؂邱ƂOłB <br>
     * ̃oCgw肳ꂽoCgȏ̏ꍇ͂̂܂ܕԂ܂B <br>
     * 
     * @param value
     *               Ƃ̕
     * @param pad
     *               l߂镶
     * @param length
     *               w肳ꂽoCg
     * @return l߂Ԃ̕
     */
    public static String padTail(String value, String pad, int length) {

        if (value.getBytes().length >= length) {
            return value;
        }

        int addNum = (length - value.getBytes().length) / pad.getBytes().length;

        StringBuffer buffer = new StringBuffer(value);

        for (int index = 0; index < addNum; index++) {
            buffer.append(pad);
        }
        return buffer.toString();
    }

    public static String getPackageAsPath(String packageName) {
        return getPackageAsPath(packageName, "/");
    }

    public static String getPackageAsPath(String packageName, String separater) {
        return replace(packageName, ClassUtils.PACKAGE_DELIM, separater);
    }

    public static String valueOf(Object obj) {
        if (obj == null)
            return EMPTY;
        return obj.toString();
    }

    public static String valueOf(byte value) {
        return String.valueOf(value);
    }

    public static String valueOf(short value) {
        return String.valueOf(value);
    }

    public static String valueOf(int value) {
        return String.valueOf(value);
    }

    public static String valueOf(long value) {
        return String.valueOf(value);
    }

    public static String valueOf(double value) {
        return String.valueOf(value);
    }

    public static String valueOf(float value) {
        return String.valueOf(value);
    }

    public static String valueOf(char value) {
        return String.valueOf(value);
    }

    public static String valueOf(boolean value) {
        return String.valueOf(value);
    }

    public static String joinIfValueNotNull(String value, String leftStr, String rightStr) {
        if (StringUtils.isEmpty(value))
            return null;
        return defaultString(leftStr) + value + defaultString(rightStr);
    }

}