/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2003/12/15
 */
package org.asyrinx.brownie.core.io.sf;

import java.io.IOException;
import java.io.InputStream;

import org.asyrinx.brownie.core.io.FileConstants;
import org.asyrinx.brownie.core.io.PathPointer;
import org.asyrinx.brownie.core.lang.ClassUtils;
import org.asyrinx.brownie.core.lang.InvocationInfo;
import org.asyrinx.brownie.core.lang.StringUtils;

/**
 * 
 * 
 * @author akima
 */
public final class RelativeClassResourceStreamFactory extends ClassResourceStreamFactory {

    /**
     *  
     */
    public RelativeClassResourceStreamFactory() {
        this(null, null);
    }

    /**
     * @param classLoader
     */
    public RelativeClassResourceStreamFactory(ClassLoader classLoader) {
        this(classLoader, null);
    }

    /**
     * @param classLoader
     */
    public RelativeClassResourceStreamFactory(String classToBeCalled) {
        this(null, classToBeCalled);
    }

    /**
     * @param classLoader
     */
    public RelativeClassResourceStreamFactory(ClassLoader classLoader, String classToBeCalled) {
        super(classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader());
        this.classToBeCalled = StringUtils.isEmpty(classToBeCalled) ? RelativeClassResourceStreamFactory.class
                .getName() : classToBeCalled;
    }

    private final String classToBeCalled;

    /*
     * pƑSłAoverrideĂ܂B
     * ȂInvocationInfop̃NXĂяoƂĔfĂ܂߂łB
     * 
     * @see org.asyrinx.brownie.core.io.sf.StreamFactory#newInput(java.lang.Object)
     */
    public InputStream newInput(Object key) throws IOException {
        return createNewInput(key);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.io.sf.AbstractFileStreamFactory#keyStringToString(java.lang.String)
     */
    protected String keyStringToString(String key) {
        final String resPath = getResourcePathBase();
        final PathPointer pointer = new PathPointer(resPath);
        pointer.goUp();
        pointer.moveTo(key);
        String realPath = pointer.getPath();
        return realPath;
    }

    /**
     * @return
     */
    private String getResourcePathBase() {
        final InvocationInfo invocationInfo = new InvocationInfo(classToBeCalled);
        final String resPath = StringUtils.replace(invocationInfo.getClassName(), ClassUtils.PACKAGE_DELIM,
                FileConstants.FILE_SPARATOR_SLASH);
        return resPath;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.asyrinx.brownie.core.io.sf.ClassResourceStreamFactory#getCaption()
     */
    public String getCaption() {
        return "class resource from" + getResourcePathBase();
    }

}