/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.io;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;

import org.asyrinx.brownie.core.lang.StringUtils;

/**
 * eLXgt@C\NXłB
 * 
 * @author Akima
 */
public class TextFile extends File {

	/**
	 * Constructor for FileContent.
	 * 
	 * @param pathname
	 */
	public TextFile(String pathname) {
		super(pathname);
	}

	/**
	 * Constructor for FileContent.
	 * 
	 * @param parent
	 * @param child
	 */
	public TextFile(File parent, String child) {
		super(parent, child);
	}

	/**
	 * Constructor for FileContent.
	 * 
	 * @param pathname
	 */
	public TextFile(String pathname, String text) {
		super(pathname);
		this.text = text;
	}

	/**
	 * Constructor for FileContent.
	 * 
	 * @param parent
	 * @param child
	 */
	public TextFile(String parent, String child, String text) {
		super(parent, child);
		this.text = text;
	}

	/**
	 * Constructor for FileContent.
	 * 
	 * @param parent
	 * @param child
	 */
	public TextFile(File parent, String child, String text) {
		super(parent, child);
		this.text = text;
	}

	private String text = null;

	/**
	 * Returns the text.
	 * 
	 * @return String
	 */
	public String getText() {
		return text;
	}

	/**
	 * Sets the text.
	 * 
	 * @param text
	 *            The text to set
	 */
	public void setText(String text) {
		this.text = text;
	}

	public void load() throws FileNotFoundException, IOException {
		load(new FileInputStream(this));
	}

	public void load(InputStream source) throws IOException {
		BufferedReader reader = new BufferedReader(
				new InputStreamReader(source));
		try {
			StringBuffer result = new StringBuffer();
			int c = reader.read();
			while (c > 0) {
				result.append((char) c);
				c = reader.read();
			}
			text = result.toString();
		} finally {
			reader.close();
		}
	}

	public void save() throws IOException {
		BufferedOutputStream bos = new BufferedOutputStream(
				new FileOutputStream(this));
		try {
			save(bos);
		} finally {
			bos.close();
		}
	}

	public void save(OutputStream dest) throws IOException {
		StringReader reader = new StringReader(text);
		StreamUtils.copy(reader, new OutputStreamWriter(dest));
		reader.close();
	}

	public boolean compare(InputStream target) throws IOException {
		return StreamUtils.compare(new StringReader(text),
				new InputStreamReader(target));
	}

	public boolean compare(String target) {
		return StringUtils.compare(this.text, target);
	}
}