package org.asyrinx.brownie.core.csv;

/**
 * CSVTSVȂǋ؂ꂽ͂NX
 * 
 * @author kadowaki
 */
public class SVTokenizer {

	/** ͂镶 */
	private String line;

	/** ؂蕶 */
	private char delim;

	/** p */
	private char quote;

	/** ł݂̌̈ʒu */
	private int current;

	/** ̍Ō̈ʒu */
	private int max;

	/**
	 * ؂蕶EpIƂ̃RXgN^
	 * 
	 * @param line
	 *            ͂镶
	 * @param delim
	 *            ؂蕶
	 * @param quote
	 *            p
	 */
	public SVTokenizer(String line, char delim, char quote) {
		this.line = line;
		this.delim = delim;
		this.quote = quote;
		current = 0;
		max = line.length();
	}

	/**
	 * ̃f[^邩ǂ𔻒肷
	 * 
	 * @return boolean ̃f[^̗L
	 */
	public boolean hasMoreTokens() {
		return (nextDelim(current) <= max);
	}

	/**
	 * ̃f[^Ԃ
	 * 
	 * @return String ̃f[^
	 */
	public String nextToken() {
		int work = current;
		current = nextDelim(current);
		StringBuffer buffer = new StringBuffer();
		while (work < current) {
			char ch = line.charAt(work++);
			if (ch != quote) {
				buffer.append(ch);
			}
		}
		current++;
		return new String(buffer);
	}

	/**
	 * ̋؂蕶̈ʒuԂ
	 * 
	 * @param position
	 *            Jnʒu
	 * @return int ̋؂蕶̈ʒu
	 */
	private int nextDelim(int position) {
		boolean inquote = false;
		while (position < max) {
			char ch = line.charAt(position);
			if (ch == quote) {
				inquote = !inquote;
			} else if (!inquote && (ch == delim)) {
				break;
			}
			position++;
		}
		return position;
	}
}