/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.core.collection.matrix;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Akima
 */
public class ArrayListMatrix implements ListMatrix {

	/**
	 * Constructor for ListMatrix.
	 */
	public ArrayListMatrix() {
		super();
	}

	private ArrayList baseRows = new ArrayList();

	private List findByRow(int row) {
		if (row < baseRows.size()) {
			return (List) baseRows.get(row);
		} else {
			return null;
		}
	}

	/*
	 * static private void addNullData(List dest, int reqestedIndex){ }
	 */

	private List needByRow(int row) {
		//List result = findByRow(row);
		while (row >= baseRows.size()) {
			baseRows.add(new ArrayList());
		}
		return (List) baseRows.get(row);
	}

	public Object get(int col, int row) {
		List source = findByRow(row);
		if (source == null)
			return null;
		if (col < source.size()) {
			return source.get(col);
		} else {
			return null;
		}
	}

	public void put(int col, int row, Object value) {
		List dest = needByRow(row);
		while (col >= dest.size()) {
			dest.add(null);
		}
		dest.set(col, value);
	}

	public void remove(int col, int row) {
		List source = findByRow(row);
		if (source == null)
			return;
		source.remove(col);
	}

	public void clear() {
		baseRows.clear();
	}

	/**
	 *  
	 */
	public int colSize() {
		int result = 0;
		for (int i = 0; i < baseRows.size(); i++) {
			List row = (List) baseRows.get(i);
			if (result < row.size()) {
				result = row.size();
			}
		}
		return result;
	}

	/**
	 */
	public int rowSize() {
		return baseRows.size();
	}

	/**
	 */
	public List getCol(int colKey) {
		if (colKey < colSize()) {
			List result = new ArrayList();
			int rowCount = rowSize();
			for (int i = 0; i < rowCount; i++) {
				result.add(get(colKey, i));
			}
			return result;
		} else {
			return null;
		}
	}

	/**
	 */
	public List getRow(int rowKey) {
		List source = findByRow(rowKey);
		if (source != null) {
			List result = new ArrayList(source);
			int colCount = colSize();
			while (result.size() < colCount) {
				result.add(null);
			}
			return result;
		} else {
			return null;
		}
	}

}