/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/09/09 1:16:31
 */
package org.asyrinx.brownie.core.collection.maptree;

import java.util.Properties;

/**
 * @author akima
 */
public class DefaultMapTreeKeyFactory implements MapTreeKeyFactory, MapTree.PropertiesAccessibleSupport {

    /**
     *  
     */
    public DefaultMapTreeKeyFactory() {
        super();
    }

    private final MapTreeKeyFactory simpleFactory = new MapTreeKeyFactory.Simple();

    private final StringMapTreeKeyFactory stringFactory = new StringMapTreeKeyFactory();

    public MapTreeKey createKey(Object object) {
        MapTreeKey result = simpleFactory.createKey(object);
        if (result == null)
            result = stringFactory.createKey(String.valueOf(object));
        return result;
    }

    /**
     * @param mapTree
     * @param source
     */
    public void loadFromProperties(MapTree mapTree, Properties source) {
        stringFactory.loadFromProperties(mapTree, source);
    }

    /**
     * @param mapTree
     * @param dest
     */
    public void saveToProperties(MapTree mapTree, Properties dest) {
        stringFactory.saveToProperties(mapTree, dest);
    }
}