/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/09/03 18:16:31
 */
package org.asyrinx.brownie.core.collection.calc;

import java.util.Iterator;
import java.util.List;

import org.asyrinx.brownie.core.lang.ArrayUtils;
import org.asyrinx.brownie.core.lang.NumberUtils;

/**
 * @author akima
 */
public interface Calculation {

    //byte -128ȏ/127ȉ
    //short -32768ȏ/32767ȉ
    //int -2147483648ȏ/2147483647ȉ
    //long -9223372036854775808ȏ/9223372036854775807ȉ
    //float IEEEPx32bit_
    //double IEEE{x64bit_

    public Number calculate(Number[] values);

    public Number calculate(List list);

    public abstract class AbstractCalculation implements Calculation {
        public Number calculate(Number[] values) {
            return calculate(ArrayUtils.toArrayList(values));
        }
    }

    public static final Calculation SUMMARY = new AbstractCalculation() {
        public Number calculate(List list) {
            double result = 0;
            for (Iterator iter = list.iterator(); iter.hasNext();) {
                final Number number = NumberUtils.toNumber(iter.next());
                result = result + number.doubleValue();
            }
            return NumberUtils.toMinimunNumberObject(result);
        }
    };

    public static final Calculation COUNT = new AbstractCalculation() {
        public Number calculate(List list) {
            return new Integer(list.size());
        }

        public Number calculate(Number[] values) {
            return new Integer(values.length);
        }
    };

    public static final Calculation AVERAGE = new AbstractCalculation() {
        /*
         * (non-Javadoc)
         * 
         * @see org.asyrinx.brownie.core.collection.calc.Calculation#calculate(java.util.List)
         */
        public Number calculate(List list) {
            return null;
        }

        public Number calculate(Number[] values) {
            final double sum = SUMMARY.calculate(values).doubleValue();
            final int count = COUNT.calculate(values).intValue();
            if (count == 0) {
                //lĂ݂count0Ȃ獇v0
                //return new Double((sum > 0) ? Double.POSITIVE_INFINITY :
                // Double.NEGATIVE_INFINITY);
                return new Double(0);
            } else {
                return NumberUtils.toMinimunNumberObject(sum / count);
            }
        }
    };

    public static final Calculation MIN = new Selection() {
        protected double select(double val1, double val2) {
            return (val1 < val2) ? val1 : val2;
        }
    };

    public static final Calculation MAX = new Selection() {
        protected double select(double val1, double val2) {
            return (val1 > val2) ? val1 : val2;
        }
    };

}