/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/04
 */
package org.asyrinx.brownie.core.collection;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

import org.asyrinx.brownie.core.lang.ArrayUtils;
import org.asyrinx.brownie.core.lang.StringUtils;

/**
 * A}bvc[\ƂĈ߂̃NXłB <br>
 * PropertiesNXւ̃VACYAfVACY\łB <br>
 * Ⴆ΁Aȉ̂悤ȗvfĂPropertiesIuWFNgƂ܂B <br>
 * 
 * <pre>
 * 
 *  
 *   
 *    
 *     
 *      
 *       
 *        
 *                aaa.aaa = 000
 *                aaa.bbb.ccc = 111
 *                aaa.bbb.ddd = 222
 *                aaa.bbb.eee.fff = 333
 *         
 *        
 *       
 *      
 *     
 *    
 *   
 *  
 * </pre>
 * 
 * PropertiesIuWFNgloadFromMapTreeIuWFNǵA IɈȉ̂悤Map̃c[쐬܂B
 * 
 * <pre>
 * 
 *  
 *   
 *    
 *     
 *      
 *       
 *        
 *                (root:Map)
 *                  - aaa = Map }
 *                    - aaa = 000 t
 *                    - bbb = Map }
 *                      - ccc = 111 t
 *                      - ddd = 222 t
 *                      - eee = Map }
 *                        - fff = 333 t
 *         
 *        
 *       
 *      
 *     
 *    
 *   
 *  
 * </pre>
 * 
 * rootƂȂMapgetRoot\bhŎ擾\łB <br>
 * ܂aaacccȂǂ̗vfgetMap\bhɂĎ擾\łB <br>
 * 
 * @author akima
 */
public class MapTree {

    /**
     *  
     */
    public MapTree() {
        this(new HashMap());
    }

    /**
     *  
     */
    public MapTree(Map root) {
        super();
        this.root = root;
    }

    /**
     *  
     */
    public MapTree(MapTree mapTree) {
        this(mapTree.getRoot());
    }

    protected final Map root;

    protected String keyDelimiter = ".";

    protected Object[] toKeys(Object key) {
        final String keyStr = String.valueOf(key);
        return StringUtils.tokenizeToArray(keyStr, keyDelimiter);
    }

    protected MapTreeKey toKey(Object key) {
        if (key == null)
            return NullMapTreeKey.getInstance();
        else if (key instanceof Object[])
            return new ArrayMapTreeKey((Object[]) key);
        else
            return new StringMapTreeKey(String.valueOf(key), keyDelimiter);

    }

    /**
     * L[ɂĎw肳ꂽ}邢͗tԂ܂B
     * 
     * @param key
     *               Object̔z񂠂邢͕ƂĈ܂B
     *               keyɃIuWFNg̔zw肵ꍇA̔z̊evfc[̎}ƂȂ܂B
     *               ̏ꍇAkeyDelimitervpeBŎw肵ɂĕA ꂽevfc[̎}ƂȂ܂B
     * 
     * @return L[ɂĎw肳ꂽ݂ȂꍇɂnullԂ܂B
     */
    public Object get(Object key) {
        return get(toKey(key));
    }

    /**
     * 
     * @param key
     * @return
     */
    public Object get(MapTreeKey key) {
        return get(key.getKeyArray());
    }

    /**
     * L[ɂĎw肳ꂽ}邢͗tԂ܂B
     * 
     * @param key
     *               z̊evfc[̎}ƂĈ܂B
     * @return L[ɂĎw肳ꂽ݂ȂꍇɂnullԂ܂B
     */
    public Object get(Object[] keys) {
        if (keys == null || keys.length == 0)
            return null;
        final Map map = (keys.length == 1) ? root : getMap(ArrayUtils.subArray(keys, 0, keys.length - 1));
        return (map == null) ? null : map.get(keys[keys.length - 1]);
    }

    /**
     * MapTreeɗvfǉ܂B
     * 
     * @param key
     *               Object̔z񂠂邢͕ƂĈ܂B
     *               keyɃIuWFNg̔zw肵ꍇA̔z̊evfc[̎}ƂȂ܂B
     *               ̏ꍇAkeyDelimitervpeBŎw肵ɂĕA ꂽevfc[̎}ƂȂ܂B
     *               AL[ɂĎw肳ꂽ݂Ȃꍇɂ͎Iɍ쐬܂B
     * 
     * @param value
     *               ǉvfłB
     */
    public void put(Object key, Object value) {
        put(toKey(key), value);
    }

    /**
     * 
     * @param key
     * @param value
     */
    public void put(MapTreeKey key, Object value) {
        put(key.getKeyArray(), value);
    }

    /**
     * @param key
     *               ̔z̊evfc[̎}ƂȂ܂B AL[ɂĎw肳ꂽ݂Ȃꍇɂ͎Iɍ쐬܂B
     * 
     * @param value
     *               ǉvfłB
     */
    public void put(Object[] keys, Object value) {
        if (keys == null || keys.length == 0)
            return;
        final Map map = (keys.length == 1) ? root : needMap(ArrayUtils.subArray(keys, 0, keys.length - 1));
        map.put(keys[keys.length - 1], value);
    }

    /**
     * MapTreeIuWFNgێ鍪MapIuWFNgԂ܂B
     * 
     * @return
     */
    public Map getRoot() {
        return root;
    }

    /**
     * L[ɂĎw肳ꂽ}MapIuWFNgԂ܂B
     * 
     * @param key
     *               Object̔z񂠂邢͕ƂĈ܂B
     *               keyɃIuWFNg̔zw肵ꍇA̔z̊evfc[̎}ƂȂ܂B
     *               ̏ꍇAkeyDelimitervpeBŎw肵ɂĕA ꂽevfc[̎}ƂȂ܂B
     * @return
     */
    public Map getMap(Object key) {
        if (key instanceof Object[]) {
            return getMap((Object[]) key);
        } else {
            return getMap(toKeys(key));
        }
    }

    /**
     * L[ɂĎw肳ꂽ}MapIuWFNgԂ܂B
     * 
     * @param key
     *               z̊evfc[̎}ƂĈ܂B
     * @return
     */
    protected Map getMap(Object[] keys) {
        Map current = root;
        for (int i = 0; i < keys.length; i++) {
            Object val = current.get(keys[i]);
            if (val instanceof Map) {
                current = (Map) val;
            } else {
                return null;
            }
        }
        return current;
    }

    protected Map needMap(Object[] keys) {
        Map current = root;
        for (int i = 0; i < keys.length; i++) {
            Object val = current.get(keys[i]);
            if (val instanceof Map) {
                current = (Map) val;
            } else {
                final Map newMap = createMap();
                current.put(keys[i], newMap);
                current = newMap;
            }
        }
        return current;
    }

    protected Map createMap() {
        return new HashMap();
    }

    /**
     * ŃL[w肵ꍇɊe}̖̂Ƃĕ邽߂̕łB
     * 
     * @return
     */
    public String getKeyDelimiter() {
        return keyDelimiter;
    }

    /**
     * ŃL[w肵ꍇɊe}̖̂Ƃĕ邽߂̕łB
     * 
     * @param string
     */
    public void setKeyDelimiter(String string) {
        keyDelimiter = string;
    }

    /**
     * ێf[^PropertiesIuWFNgɃVACY܂B
     * 
     * @param properties
     */
    public void saveTo(Properties properties) {
        final Properties props = properties;
        final MapTreeVisitor visitor = new MapTreeVisitor(this.root) {
            public void doOnLeaf(Object value) {
                final String key = StringUtils.join(keyStack.iterator(), keyDelimiter);
                props.put(key, value);
            }
        };
        visitor.execute();
    }

    /**
     * PropertiesIuWFNgf[^fVACY܂B
     * 
     * @param properties
     */
    public void loadFrom(Properties properties) {
        final Iterator iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            final Object key = iterator.next();
            this.put(key, properties.get(key));
        }
    }

}

class NullMapTreeKey implements MapTreeKey {
    static final Object[] result = new Object[0];

    public Object[] getKeyArray() {
        return result;
    }

    private static final MapTreeKey instance = new NullMapTreeKey();

    public static MapTreeKey getInstance() {
        return instance;
    }
}

class ArrayMapTreeKey implements MapTreeKey {
    public ArrayMapTreeKey(Object[] keys) {
        this.keys = keys;
    }

    final Object[] keys;

    public Object[] getKeyArray() {
        return this.keys;
    }
}

class StringMapTreeKey extends ArrayMapTreeKey {
    public StringMapTreeKey(String keyString, String keyDelimiter) {
        super(toKeys(keyString, keyDelimiter));
    }

    private static Object[] toKeys(String keyString, String keyDelimiter) {
        final String keyStr = String.valueOf(keyString);
        return StringUtils.tokenizeToArray(keyStr, keyDelimiter);
    }

}