/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/09/09 1:49:35
 */
package org.asyrinx.brownie.core.collection;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;

/**
 * @author akima
 */
public interface MapFactory {

    public Map createMap();

    public static final MapFactory HashMap = new MapFactory() {
        public Map createMap() {
            return new HashMap();
        }
    };

    public static final MapFactory Hashtable = new MapFactory() {
        public Map createMap() {
            return new Hashtable();
        }
    };

    public static final MapFactory TreeMap = new MapFactory() {
        public Map createMap() {
            return new TreeMap();
        }
    };

    public static final class Syncronized implements MapFactory {
        public Syncronized(MapFactory factory) {
            this.factory = factory;
        }

        private final MapFactory factory;

        public Map createMap() {
            return Collections.synchronizedMap(factory.createMap());
        }
    }

}