/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/09/09 4:10:56
 */
package org.asyrinx.brownie.core.collection;

import org.apache.commons.collections.Closure;
import org.apache.commons.collections.Predicate;

/**
 * @author akima
 */
public class ClosureUtils {

    /**
     *  
     */
    public ClosureUtils() {
        super();
    }

    public static Predicate inverse(Predicate predicate) {
        return new InversedPredicate(predicate);
    }

    public static Closure withPrecondition(Predicate precondition, Closure closure) {
        return new PreconditionedClosure(precondition, closure);
    }

    public static Closure composite(Closure[] closures) {
        return new CompositeClosure(closures);
    }

}

class InversedPredicate implements Predicate {
    InversedPredicate(Predicate predicate) {
        this.predicate = predicate;
    }

    final Predicate predicate;

    public boolean evaluate(Object input) {
        return !predicate.evaluate(input);
    }
}

class PreconditionedClosure implements Closure {
    PreconditionedClosure(Predicate precondition, Closure closure) {
        this.precondition = precondition;
        this.closure = closure;
    }

    final Predicate precondition;

    final Closure closure;

    public void execute(Object input) {
        if (precondition.evaluate(input))
            closure.execute(input);
    }
}

class CompositeClosure implements Closure {
    CompositeClosure(Closure[] closures) {
        this.closures = closures;
    }

    final Closure[] closures;

    public void execute(Object input) {
        for (int i = 0; i < closures.length; i++) {
            closures[i].execute(input);
        }
    }
}