/*
 * joey-rt-test and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/15 1:13:38
 */
package org.asyrinx.joey.tapestry.components.entity.table.impl;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.asyrinx.joey.tapestry.components.entity.table.IListTableColumnProperty;

/**
 * @author takeshi
 */
public abstract class ListTableColumn extends AbstractListTableColumn implements IListTableColumnProperty {

    public void renderCellContents(IMarkupWriter writer, IRequestCycle cycle) {
        if (getBodyCount() > 1)
            renderBody(writer, cycle);
        else
            getRow().renderCellContent(writer, cycle);
    }

    public Object getValue(Object bean) {
        if (!StringUtils.isEmpty(getValue()))
            return getValue();
        if (StringUtils.isEmpty(getProperty()))
            return getValue();
        try {
            return PropertyUtils.getProperty(bean, getProperty());
        } catch (Exception e) {
            throw new ApplicationRuntimeException(e);
        }
    }

}