/*
 * joey-rt and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/12/12 1:01:02
 */
package org.asyrinx.joey.entity.service.impl;

import java.io.Serializable;
import java.util.List;

import net.sf.hibernate.exception.NestableRuntimeException;

import org.apache.commons.beanutils.MethodUtils;
import org.asyrinx.brownie.core.query.exp.IExpression;
import org.asyrinx.joey.entity.service.EntityServiceDictionary;
import org.asyrinx.joey.entity.service.EntityServiceDispatcher;
import org.asyrinx.joey.entity.service.EntityServiceException;

/**
 * @author takeshi
 */
public class EntityServiceDispatcherImpl implements EntityServiceDispatcher {

    /**
     *  
     */
    public EntityServiceDispatcherImpl(EntityServiceDictionary serviceDictionary) {
        super();
        this.serviceDictionary = serviceDictionary;
    }

    private final EntityServiceDictionary serviceDictionary;

    protected Object getService(Class entityClass) {
        return serviceDictionary.getService(entityClass);
    }

    public void delete(Object entity) {
        final Object service = getService(entity.getClass());
        try {
            MethodUtils.invokeMethod(service, "delete", entity);
        } catch (Exception e) {
            throw new NestableRuntimeException(e);
        }
    }

    public void save(Object entity) {
        final Object service = getService(entity.getClass());
        try {
            MethodUtils.invokeMethod(service, "save", entity);
        } catch (Exception e) {
            throw new NestableRuntimeException(e);
        }
    }

    public Object load(Class entityClass, Serializable key) {
        final Object service = getService(entityClass);
        try {
            return MethodUtils.invokeMethod(service, "load", key);
        } catch (Exception e) {
            throw new NestableRuntimeException(e);
        }
    }

    public List select(Class entityClass, IExpression condition) {
        final Object service = getService(entityClass);
        try {
            final Object result = MethodUtils.invokeMethod(service, "select", condition);
            if (!(result instanceof List))
                throw new EntityServiceException("");
            return (List) result;
        } catch (Exception e) {
            throw new NestableRuntimeException(e);
        }
    }
}