/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/09/05 17:22:04
 */
package test.org.asyrinx.brownie.swing.table;

import javax.swing.table.DefaultTableModel;

import junit.framework.TestCase;

import org.asyrinx.brownie.core.collection.calc.Calculation;
import org.asyrinx.brownie.swing.table.TableUtils;
import org.asyrinx.brownie.swing.table.calc.CalcTableModel;

/**
 * @author akima
 */
public class CalculatableTableModelTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(CalculatableTableModelTest.class);
    }

    public void testToCalculatableKey1() {
        final DefaultTableModel tableModel = new DefaultTableModel();
        tableModel.addColumn("key");
        tableModel.addColumn("col1");
        tableModel.addColumn("col2");
        tableModel.addColumn("col3");
        tableModel.addColumn("col4");
        tableModel.addRow(new Object[] { "A", "1", "2-0", "1", "z" });
        tableModel.addRow(new Object[] { "A", "-10", "2-1", "2", "x" });
        tableModel.addRow(new Object[] { "B", "20", "2-2", "11", "a" });
        tableModel.addRow(new Object[] { "C", "11", "2-3", "00", "y" });
        tableModel.addRow(new Object[] { "C", "99", "2-3", "00", "y" });
        //
        final CalcTableModel calculatable = TableUtils.toCalculatable(tableModel, new int[] { 0 });
        calculatable.addCalcColumn(1, Calculation.SUMMARY);
        calculatable.addCalcColumn(1, Calculation.AVERAGE);
        //
        assertEquals(3, calculatable.getColumnCount());
        assertEquals(3, calculatable.getRowCount());
        assertEquals("key", calculatable.getColumnName(0));
        assertEquals("sum(col1)", calculatable.getColumnName(1));
        assertEquals("average(col1)", calculatable.getColumnName(2));
        assertEquals("A", calculatable.getValueAt(0, 0));
        assertEquals("B", calculatable.getValueAt(1, 0));
        assertEquals("C", calculatable.getValueAt(2, 0));
        assertEquals("-9", calculatable.getValueAt(0, 1).toString());
        assertEquals("20", calculatable.getValueAt(1, 1).toString());
        assertEquals("110", calculatable.getValueAt(2, 1).toString());
        assertEquals("-4.5", calculatable.getValueAt(0, 2).toString());
        assertEquals("20", calculatable.getValueAt(1, 2).toString());
        assertEquals("55", calculatable.getValueAt(2, 2).toString());
    }

    public void testToCalculatableKey2() {
        final DefaultTableModel tableModel = new DefaultTableModel();
        tableModel.addColumn("key");
        tableModel.addColumn("col1");
        tableModel.addColumn("col2");
        tableModel.addColumn("col3");
        tableModel.addColumn("col4");
        tableModel.addRow(new Object[] { "A", "1", "2-0", "1", "z" });
        tableModel.addRow(new Object[] { "A", "6", "2-0", "1", "z" });
        tableModel.addRow(new Object[] { "A", "-10", "2-1", "2", "x" });
        tableModel.addRow(new Object[] { "B", "20", "2-2", "11", "a" });
        tableModel.addRow(new Object[] { "C", "123", "2-3", "00", "z" });
        tableModel.addRow(new Object[] { "C", "11", "2-3", "00", "y" });
        tableModel.addRow(new Object[] { "C", "99", "2-3", "00", "y" });
        //
        final CalcTableModel calculatable = TableUtils.toCalculatable(tableModel, new int[] { 4, 0 });
        calculatable.addCalcColumn(1, Calculation.COUNT);
        calculatable.addCalcColumn(1, Calculation.AVERAGE);
        //
        assertEquals(4, calculatable.getColumnCount());
        assertEquals(5, calculatable.getRowCount());
        assertEquals("col4", calculatable.getColumnName(0));
        assertEquals("key", calculatable.getColumnName(1));
        assertEquals("count(col1)", calculatable.getColumnName(2));
        assertEquals("average(col1)", calculatable.getColumnName(3));
        //
        assertEquals("z", calculatable.getValueAt(0, 0));
        assertEquals("x", calculatable.getValueAt(1, 0));
        assertEquals("a", calculatable.getValueAt(2, 0));
        assertEquals("z", calculatable.getValueAt(3, 0));
        assertEquals("y", calculatable.getValueAt(4, 0));
        //
        assertEquals("A", calculatable.getValueAt(0, 1));
        assertEquals("A", calculatable.getValueAt(1, 1));
        assertEquals("B", calculatable.getValueAt(2, 1));
        assertEquals("C", calculatable.getValueAt(3, 1));
        assertEquals("C", calculatable.getValueAt(4, 1));
        //
        assertEquals("2", calculatable.getValueAt(0, 2).toString());
        assertEquals("1", calculatable.getValueAt(1, 2).toString());
        assertEquals("1", calculatable.getValueAt(2, 2).toString());
        assertEquals("1", calculatable.getValueAt(3, 2).toString());
        assertEquals("2", calculatable.getValueAt(4, 2).toString());
        //
        assertEquals("3.5", calculatable.getValueAt(0, 3).toString());
        assertEquals("-10", calculatable.getValueAt(1, 3).toString());
        assertEquals("20", calculatable.getValueAt(2, 3).toString());
        assertEquals("123", calculatable.getValueAt(3, 3).toString());
        assertEquals("55", calculatable.getValueAt(4, 3).toString());
    }

    public void testToCalculatableModifyKey() {
        final DefaultTableModel tableModel = new DefaultTableModel();
        tableModel.addColumn("key");
        tableModel.addColumn("col1");
        tableModel.addColumn("col2");
        tableModel.addColumn("col3");
        tableModel.addColumn("col4");
        tableModel.addRow(new Object[] { "A", "1", "2-0", "1", "z" });
        tableModel.addRow(new Object[] { "A", "6", "2-0", "1", "z" });
        tableModel.addRow(new Object[] { "A", "-10", "2-1", "2", "x" });
        tableModel.addRow(new Object[] { "B", "20", "2-2", "11", "a" });
        tableModel.addRow(new Object[] { "C", "123", "2-3", "00", "z" });
        tableModel.addRow(new Object[] { "C", "11", "2-3", "00", "y" });
        tableModel.addRow(new Object[] { "C", "99", "2-3", "00", "y" });
        //
        final CalcTableModel calculatable = TableUtils.toCalculatable(tableModel, new int[] { 4, 0 });
        calculatable.addCalcColumn(1, Calculation.COUNT);
        calculatable.addCalcColumn(1, Calculation.AVERAGE);
        //
        assertEquals(4, calculatable.getColumnCount());
        assertEquals(5, calculatable.getRowCount());
        assertEquals("col4", calculatable.getColumnName(0));
        assertEquals("key", calculatable.getColumnName(1));
        assertEquals("count(col1)", calculatable.getColumnName(2));
        assertEquals("average(col1)", calculatable.getColumnName(3));
        //
        assertEquals("z", calculatable.getValueAt(0, 0));
        assertEquals("x", calculatable.getValueAt(1, 0));
        assertEquals("a", calculatable.getValueAt(2, 0));
        assertEquals("z", calculatable.getValueAt(3, 0));
        assertEquals("y", calculatable.getValueAt(4, 0));
        //
        assertEquals("A", calculatable.getValueAt(0, 1));
        assertEquals("A", calculatable.getValueAt(1, 1));
        assertEquals("B", calculatable.getValueAt(2, 1));
        assertEquals("C", calculatable.getValueAt(3, 1));
        assertEquals("C", calculatable.getValueAt(4, 1));
        //
        assertEquals("2", calculatable.getValueAt(0, 2).toString());
        assertEquals("1", calculatable.getValueAt(1, 2).toString());
        assertEquals("1", calculatable.getValueAt(2, 2).toString());
        assertEquals("1", calculatable.getValueAt(3, 2).toString());
        assertEquals("2", calculatable.getValueAt(4, 2).toString());
        //
        assertEquals("3.5", calculatable.getValueAt(0, 3).toString());
        assertEquals("-10", calculatable.getValueAt(1, 3).toString());
        assertEquals("20", calculatable.getValueAt(2, 3).toString());
        assertEquals("123", calculatable.getValueAt(3, 3).toString());
        assertEquals("55", calculatable.getValueAt(4, 3).toString());
        //
        //Cxg
        tableModel.setValueAt("D", 6, 0);
        assertEquals(4, calculatable.getColumnCount());
        assertEquals(6, calculatable.getRowCount());
        assertEquals("col4", calculatable.getColumnName(0));
        assertEquals("key", calculatable.getColumnName(1));
        assertEquals("count(col1)", calculatable.getColumnName(2));
        assertEquals("average(col1)", calculatable.getColumnName(3));
        //
        assertEquals("z", calculatable.getValueAt(0, 0));
        assertEquals("x", calculatable.getValueAt(1, 0));
        assertEquals("a", calculatable.getValueAt(2, 0));
        assertEquals("z", calculatable.getValueAt(3, 0));
        assertEquals("y", calculatable.getValueAt(4, 0));
        assertEquals("y", calculatable.getValueAt(5, 0));
        //
        assertEquals("A", calculatable.getValueAt(0, 1));
        assertEquals("A", calculatable.getValueAt(1, 1));
        assertEquals("B", calculatable.getValueAt(2, 1));
        assertEquals("C", calculatable.getValueAt(3, 1));
        assertEquals("C", calculatable.getValueAt(4, 1));
        assertEquals("D", calculatable.getValueAt(5, 1));
        //
        assertEquals("2", calculatable.getValueAt(0, 2).toString());
        assertEquals("1", calculatable.getValueAt(1, 2).toString());
        assertEquals("1", calculatable.getValueAt(2, 2).toString());
        assertEquals("1", calculatable.getValueAt(3, 2).toString());
        assertEquals("1", calculatable.getValueAt(4, 2).toString());
        assertEquals("1", calculatable.getValueAt(5, 2).toString());
        //
        assertEquals("3.5", calculatable.getValueAt(0, 3).toString());
        assertEquals("-10", calculatable.getValueAt(1, 3).toString());
        assertEquals("20", calculatable.getValueAt(2, 3).toString());
        assertEquals("123", calculatable.getValueAt(3, 3).toString());
        assertEquals("11", calculatable.getValueAt(4, 3).toString());
        assertEquals("99", calculatable.getValueAt(5, 3).toString());
    }

    public void testToCalculatableModifyValue() {
        final DefaultTableModel tableModel = new DefaultTableModel();
        tableModel.addColumn("key");
        tableModel.addColumn("col1");
        tableModel.addColumn("col2");
        tableModel.addColumn("col3");
        tableModel.addColumn("col4");
        tableModel.addRow(new Object[] { "A", "1", "2-0", "1", "z" });
        tableModel.addRow(new Object[] { "A", "6", "2-0", "1", "z" });
        tableModel.addRow(new Object[] { "A", "-10", "2-1", "2", "x" });
        tableModel.addRow(new Object[] { "B", "20", "2-2", "11", "a" });
        tableModel.addRow(new Object[] { "C", "123", "2-3", "00", "z" });
        tableModel.addRow(new Object[] { "C", "11", "2-3", "00", "y" });
        tableModel.addRow(new Object[] { "C", "99", "2-3", "00", "y" });
        //
        final CalcTableModel calculatable = TableUtils.toCalculatable(tableModel, new int[] { 4, 0 });
        calculatable.addCalcColumn(1, Calculation.COUNT);
        calculatable.addCalcColumn(1, Calculation.AVERAGE);
        //
        assertEquals(4, calculatable.getColumnCount());
        assertEquals(5, calculatable.getRowCount());
        assertEquals("col4", calculatable.getColumnName(0));
        assertEquals("key", calculatable.getColumnName(1));
        assertEquals("count(col1)", calculatable.getColumnName(2));
        assertEquals("average(col1)", calculatable.getColumnName(3));
        //
        assertEquals("z", calculatable.getValueAt(0, 0));
        assertEquals("x", calculatable.getValueAt(1, 0));
        assertEquals("a", calculatable.getValueAt(2, 0));
        assertEquals("z", calculatable.getValueAt(3, 0));
        assertEquals("y", calculatable.getValueAt(4, 0));
        //
        assertEquals("A", calculatable.getValueAt(0, 1));
        assertEquals("A", calculatable.getValueAt(1, 1));
        assertEquals("B", calculatable.getValueAt(2, 1));
        assertEquals("C", calculatable.getValueAt(3, 1));
        assertEquals("C", calculatable.getValueAt(4, 1));
        //
        assertEquals("2", calculatable.getValueAt(0, 2).toString());
        assertEquals("1", calculatable.getValueAt(1, 2).toString());
        assertEquals("1", calculatable.getValueAt(2, 2).toString());
        assertEquals("1", calculatable.getValueAt(3, 2).toString());
        assertEquals("2", calculatable.getValueAt(4, 2).toString());
        //
        assertEquals("3.5", calculatable.getValueAt(0, 3).toString());
        assertEquals("-10", calculatable.getValueAt(1, 3).toString());
        assertEquals("20", calculatable.getValueAt(2, 3).toString());
        assertEquals("123", calculatable.getValueAt(3, 3).toString());
        assertEquals("55", calculatable.getValueAt(4, 3).toString());
        //
        //Cxg
        tableModel.setValueAt("0", 6, 1);
        assertEquals(4, calculatable.getColumnCount());
        assertEquals(5, calculatable.getRowCount());
        assertEquals("col4", calculatable.getColumnName(0));
        assertEquals("key", calculatable.getColumnName(1));
        assertEquals("count(col1)", calculatable.getColumnName(2));
        assertEquals("average(col1)", calculatable.getColumnName(3));
        //
        assertEquals("z", calculatable.getValueAt(0, 0));
        assertEquals("x", calculatable.getValueAt(1, 0));
        assertEquals("a", calculatable.getValueAt(2, 0));
        assertEquals("z", calculatable.getValueAt(3, 0));
        assertEquals("y", calculatable.getValueAt(4, 0));
        //
        assertEquals("A", calculatable.getValueAt(0, 1));
        assertEquals("A", calculatable.getValueAt(1, 1));
        assertEquals("B", calculatable.getValueAt(2, 1));
        assertEquals("C", calculatable.getValueAt(3, 1));
        assertEquals("C", calculatable.getValueAt(4, 1));
        //
        assertEquals("2", calculatable.getValueAt(0, 2).toString());
        assertEquals("1", calculatable.getValueAt(1, 2).toString());
        assertEquals("1", calculatable.getValueAt(2, 2).toString());
        assertEquals("1", calculatable.getValueAt(3, 2).toString());
        assertEquals("2", calculatable.getValueAt(4, 2).toString());
        //
        assertEquals("3.5", calculatable.getValueAt(0, 3).toString());
        assertEquals("-10", calculatable.getValueAt(1, 3).toString());
        assertEquals("20", calculatable.getValueAt(2, 3).toString());
        assertEquals("123", calculatable.getValueAt(3, 3).toString());
        assertEquals("5.5", calculatable.getValueAt(4, 3).toString());
    }
}