/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package test.org.asyrinx.brownie.core.util;

import java.util.Locale;
import java.util.Set;

import junit.framework.TestCase;

import org.asyrinx.brownie.core.util.Era;
import org.asyrinx.brownie.core.util.EraGroup;
import org.asyrinx.brownie.core.util.SimpleDate;

/**
 * @author akima
 */
public class EraTest extends TestCase {

	/**
	 * Constructor for EraTest.
	 * @param name
	 */
	public EraTest(String name) {
		super(name);
	}

	public static void main(String[] args) {
		junit.swingui.TestRunner.run(EraTest.class);
	}

	static final Locale JP = Locale.JAPAN;
	static final Locale EN = Locale.ENGLISH;

	final EraGroup eraGroup = new EraGroup();

	final Era JP_ERA1 =
		new Era(JP, "First era", "1st", "1", 0, 0, 0, 201, 7, 12);
	final Era JP_ERA2 =
		new Era(JP, "Second era", "2nd", "2", 201, 7, 13, 399, 3, 1);
	final Era JP_ERA3 =
		new Era(JP, "Third era", "3rd", "3", 399, 3, 2, 0, 0, 0);
	final Era EN_ERA1 =
		new Era(EN, "First era en", "1st en", "1en", 0, 0, 0, 251, 9, 11);
	final Era EN_ERA2 =
		new Era(EN, "Second era en", "2nd en", "2en", 251, 9, 12, 0, 0, 0);

	/**
	 * @throws java.lang.Exception
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		eraGroup.add(JP_ERA1);
		eraGroup.add(JP_ERA2);
		eraGroup.add(JP_ERA3);
		eraGroup.add(EN_ERA1);
		eraGroup.add(EN_ERA2);
	}

	public void testGetEras() {
		final Set englishEras = eraGroup.getEras(Locale.ENGLISH);
		assertEquals(2, englishEras.size());
		assertTrue(englishEras.contains(EN_ERA1));
		assertTrue(englishEras.contains(EN_ERA2));
		//
		final Set japanEras = eraGroup.getEras(Locale.JAPAN);
		assertEquals(3, japanEras.size());
		assertTrue(japanEras.contains(JP_ERA1));
		assertTrue(japanEras.contains(JP_ERA2));
		assertTrue(japanEras.contains(JP_ERA3));
	}

	/*
	 * Test for Era getEra(Locale, SimpleDate)
	 */
	public void testGetEraLocaleSimpleDate() {
		assertEquals(JP_ERA1, eraGroup.getEra(JP, new SimpleDate(-100, 3, 22)));
		assertEquals(JP_ERA1, eraGroup.getEra(JP, new SimpleDate(0, 0, 1)));
		assertEquals(JP_ERA1, eraGroup.getEra(JP, new SimpleDate(1, 0, 1)));
		assertEquals(JP_ERA1, eraGroup.getEra(JP, new SimpleDate(201, 7, 12)));
		assertEquals(JP_ERA2, eraGroup.getEra(JP, new SimpleDate(201, 7, 13)));
		assertEquals(JP_ERA2, eraGroup.getEra(JP, new SimpleDate(300, 7, 13)));
		assertEquals(JP_ERA2, eraGroup.getEra(JP, new SimpleDate(399, 3, 1)));
		assertEquals(JP_ERA3, eraGroup.getEra(JP, new SimpleDate(399, 3, 2)));
		assertEquals(JP_ERA3, eraGroup.getEra(JP, new SimpleDate(9999, 10, 3)));
	}

	public void testFindByCaptions() {
		assertEquals(null, eraGroup.findByCaptions(null));
		assertEquals(null, eraGroup.findByCaptions(""));
		assertEquals(null, eraGroup.findByCaptions("asdf"));
		assertEquals(JP_ERA2, eraGroup.findByCaptions("Second era"));
		assertEquals(JP_ERA2, eraGroup.findByCaptions("2nd"));
		assertEquals(JP_ERA2, eraGroup.findByCaptions("2"));
	}

	public void testGetYearAt() {
		assertEquals(101, JP_ERA1.getYearAt(new SimpleDate(100, 1, 4)));
		assertEquals(301, JP_ERA1.getYearAt(new SimpleDate(300, 1, 4)));
		assertEquals(-100, JP_ERA2.getYearAt(new SimpleDate(100, 1, 4)));
		assertEquals(1, JP_ERA2.getYearAt(new SimpleDate(201, 1, 4)));
		assertEquals(73, JP_ERA2.getYearAt(new SimpleDate(273, 1, 4)));
		assertEquals(250, JP_ERA2.getYearAt(new SimpleDate(450, 1, 4)));
	}

	/*
	 * Test for int getEraYear(Locale, SimpleDate)
	 */
	public void testGetEraYearLocaleSimpleDate() {
		assertEquals(101, eraGroup.getEraYear(JP, new SimpleDate(100, 1, 4)));
		assertEquals(202, eraGroup.getEraYear(JP, new SimpleDate(201, 1, 4)));
		assertEquals(1, eraGroup.getEraYear(JP, new SimpleDate(201, 7, 13)));
		assertEquals(73, eraGroup.getEraYear(JP, new SimpleDate(273, 1, 4)));
	}

	public void testToAnnoDomini() {
		assertEquals(100, JP_ERA1.toAnnoDomini(101));
		assertEquals(300, JP_ERA1.toAnnoDomini(301));
		assertEquals(100, JP_ERA2.toAnnoDomini(-100));
		assertEquals(201, JP_ERA2.toAnnoDomini(1));
		assertEquals(273, JP_ERA2.toAnnoDomini(73));
		assertEquals(450, JP_ERA2.toAnnoDomini(250));
	}

}
