/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/11/19 21:50:24
 */
package test.org.asyrinx.brownie.core.query;

import junit.framework.TestCase;

import org.asyrinx.brownie.core.query.exp.CompositeExpression;
import org.asyrinx.brownie.core.query.exp.IExpression;
import org.asyrinx.brownie.core.query.exp.ObjectExpression;

/**
 * @author takeshi
 */
public class FieldExpressionTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(FieldExpressionTest.class);
    }

    /*
     * Class under test for String toString()
     */
    public void testToString() {
        final ObjectExpression exp1 = new ObjectExpression("name", IExpression.LIKE, "*aki*");
        final ObjectExpression exp2 = new ObjectExpression("price", IExpression.GREATER_EQUAL, new Integer(1257));
        assertEquals("name like *aki*", exp1.toString());
        assertEquals("price >= 1257", exp2.toString());
        //
        final CompositeExpression compositeExcpression = new CompositeExpression();
        compositeExcpression.setOperator(IExpression.AND);
        compositeExcpression.add(exp1);
        compositeExcpression.add(exp2);
        assertEquals("(name like *aki*)and(price >= 1257)", compositeExcpression.toString());
    }

    public void testComposite() {
        final CompositeExpression compo1 = new CompositeExpression(IExpression.OR);
        compo1.add(new ObjectExpression("field1", IExpression.EQUAL, "123")).addCompo(IExpression.AND).add(
                new ObjectExpression("field2", IExpression.LESS, "456")).add(
                new ObjectExpression("field3", IExpression.GREATER_EQUAL, "789"));
        assertEquals("(field1 = 123)or((field2 < 456)and(field3 >= 789))", compo1.toString());
    }

}