/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2003/12/15
 */
package test.org.asyrinx.brownie.core.io;

import junit.framework.TestCase;

import org.asyrinx.brownie.core.io.PathPointer;

/**
 * @author akima
 */
public class PathPointerTest extends TestCase {

	/**
	 * Constructor for PathPointerTest.
	 * @param name
	 */
	public PathPointerTest(String name) {
		super(name);
	}

	public static void main(String[] args) {
		junit.swingui.TestRunner.run(PathPointerTest.class);
	}

	public void testSetPath() {
		final PathPointer pointer = new PathPointer("C:\\a1\\b1\\c1");
		assertEquals("C:\\a1\\b1\\c1", pointer.getPath());
		pointer.setPath("C:\\a2\\b3\\c4");
		assertEquals("C:\\a2\\b3\\c4", pointer.getPath());
	}

	public void testChange() {
		final PathPointer pointer = new PathPointer("C:\\a1\\b1\\c1");
		pointer.moveTo(".");
		assertEquals("C:\\a1\\b1\\c1", pointer.getPath());
		pointer.moveTo("..");
		assertEquals("C:\\a1\\b1", pointer.getPath());
		pointer.moveTo("../b2/c2/d2");
		assertEquals("C:\\a1\\b2\\c2\\d2", pointer.getPath());
		pointer.moveTo("../../c3");
		assertEquals("C:\\a1\\b2\\c3", pointer.getPath());
	}

	public void testChange2() {
		final PathPointer pointer =
			new PathPointer("C:\\Program Files\\Apache Group\\Tomcat 4.1\\webapps\\chiffon\\");
		assertEquals(
			"C:\\Program Files\\Apache Group\\Tomcat 4.1\\webapps\\chiffon",
			pointer.getPath());
		pointer.moveTo("\\WEB-INF\\conf\\log4j.xml");
		assertEquals(
			"C:\\Program Files\\Apache Group\\Tomcat 4.1\\webapps\\chiffon\\WEB-INF\\conf\\log4j.xml",
			pointer.getPath());
	}

}
