/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/08
 */
package org.asyrinx.brownie.tapestry.script;

import java.util.HashMap;
import java.util.Map;

import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IScript;
import org.apache.tapestry.html.Body;

/**
 * @author akima
 */
public class ScriptWriter {

	/**
	 *  
	 */
	public ScriptWriter(IScriptUser user, String scriptName) {
		super();
		this.user = user;
		this.scriptName = scriptName;
	}

	private final IScriptUser user;

	private final String scriptName;

	private ScriptUsage usage = ScriptUsage.EVERYTIME;

	public void checkBeforeWrite(IRequestCycle cycle) {
		final Body body = Body.get(cycle);
		if (body == null)
			throw new ApplicationRuntimeException("must-be-contained-by-body",
					this, null, null);
	}

	public void execute(IRequestCycle cycle) {
		checkBeforeWrite(cycle);
		if (!this.usage.canWrite(this.user, cycle))
			return;
		final Map symbols = new HashMap();
		user.prepareScriptSymbols(symbols, cycle);
		final Body body = Body.get(cycle);
		loadScript(this.user).execute(cycle, body, symbols);
	}

	private IScript script = null;

	/**
	 * @return
	 */
	protected IScript loadScript(IComponent component) {
		if (script == null)
			script = ScriptUtils.loadScript(component, this.scriptName);
		return script;
	}

	/**
	 * @return
	 */
	public String getScriptName() {
		return scriptName;
	}

	/**
	 * @return
	 */
	public IScriptUser getUser() {
		return user;
	}

	/**
	 * @return
	 */
	public ScriptUsage getUsage() {
		return usage;
	}

	/**
	 * @param usage
	 */
	public void setUsage(ScriptUsage usage) {
		this.usage = usage;
	}

}