/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/16
 */
package org.asyrinx.brownie.tapestry.components.form;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.tapestry.form.IPropertySelectionModel;

/**
 * @author akima
 */
public class SimpleObjectPropertySelectModel implements IPropertySelectionModel {

	/**
	 *  
	 */
	public SimpleObjectPropertySelectModel(Object[] objects, String propertyName) {
		super();
		this.objects = objects;
		this.propertyName = propertyName;
	}

	private final Object[] objects;

	private final String propertyName;

	/**
	 * @see org.apache.tapestry.form.IPropertySelectionModel#getOptionCount()
	 */
	public int getOptionCount() {
		return objects.length;
	}

	/**
	 * @see org.apache.tapestry.form.IPropertySelectionModel#getOption(int)
	 */
	public Object getOption(int index) {
		return objects[index];
	}

	/**
	 * @see org.apache.tapestry.form.IPropertySelectionModel#getLabel(int)
	 */
	public String getLabel(int index) {
		try {
			return String.valueOf(PropertyUtils.getProperty(objects[index],
					propertyName));
		} catch (Exception e) {
			return "failed to get label";
		}
	}

	/**
	 * @see org.apache.tapestry.form.IPropertySelectionModel#getValue(int)
	 */
	public String getValue(int index) {
		return Integer.toString(index);
	}

	/**
	 * @see org.apache.tapestry.form.IPropertySelectionModel#translateValue(java.lang.String)
	 */
	public Object translateValue(String value) {
		int index = Integer.parseInt(value);
		return objects[index];
	}

}