/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/09/07 0:22:19
 */
package org.asyrinx.brownie.swing.table.key;

import org.apache.commons.lang.ArrayUtils;

/**
 * @author akima
 */
public class RowKey {

    public RowKey(Object[] values) {
        super();
        this.values = values;
    }

    private int[] targetRowIndexes = new int[] {};

    public void addTargetRowIndex(int rowIndex) {
        final int[] newValue = new int[targetRowIndexes.length + 1];
        for (int i = 0; i < targetRowIndexes.length; i++)
            newValue[i] = targetRowIndexes[i];
        newValue[newValue.length - 1] = rowIndex;
        this.targetRowIndexes = newValue;
    }

    public Object getValue(int keyIndex) {
        return values[keyIndex];
    }
    
    Object[] getValues(){
        return values;
    }

    /**
     * @param tableModel
     * @return
     */
    public int[] getTargetKeyIndexes() {
        return this.targetRowIndexes;
    }

    private final Object[] values;

    public boolean equals(Object obj) {
        if (obj instanceof RowKey) {
            final RowKey key = (RowKey) obj;
            return ArrayUtils.isEquals(this.values, key.values);
        } else if (obj.getClass().isArray() && obj.getClass().getComponentType() == Object.class) {
            return ArrayUtils.isEquals(this.values, obj);
        } else {
            throw new UnsupportedOperationException();
        }
    }

}