/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/09/07 2:36:07
 */
package org.asyrinx.brownie.swing.table.key;

import javax.swing.table.TableModel;


/**
 * @author akima
 */
public class KeyColumn extends AbstractColumn implements Column {

    /**
     * @param originalColumnIndex
     * @param tableModel
     * @param keyContainer
     * @param keyIndex
     */
    public KeyColumn(int originalColumnIndex, TableModel tableModel, RowKeyContainer keyContainer, int keyIndex) {
        super(originalColumnIndex, tableModel, keyContainer);
        this.keyIndex = keyIndex;
    }

    private final int keyIndex;

    public Object getValueAt(int rowIndex) {
        final RowKey key = keyContainer.getKey(rowIndex);
        return key.getValue(keyIndex);
    }

    public String getColumnName() {
        return tableModel.getColumnName(getOriginalColumnIndex());
    }

    public Class getColumnClass() {
        return Object.class;
    }

}