/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/07/12 0:00:57
 */
package org.asyrinx.brownie.swing.content;

import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;

import javax.swing.JFrame;
import javax.swing.JPanel;

/**
 * @author akima
 * 
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */
public class ContentFrame extends JFrame {

	protected final Component content;

	/**
	 * @param title
	 * @throws java.awt.HeadlessException
	 */
	public ContentFrame(Component content, String title)
			throws HeadlessException {
		super(title);
		this.content = content;
		intiPane();
	}

	protected void intiPane() {
		if (content instanceof Container) {
			this.setContentPane((Container) content);
		} else {
			final JPanel panel = new JPanel();
			panel.add(content);
			this.setContentPane(panel);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.awt.Window#show()
	 */
	public void show() {
		invokeBeforeShow();
		super.show();
		invokeAfterShow();
	}

	/**
	 *  
	 */
	protected void invokeBeforeShow() {
		if (content instanceof WindowContent)
			((WindowContent) content).beforeShow();
	}

	/**
	 *  
	 */
	protected void invokeAfterShow() {
		if (content instanceof WindowContent)
			((WindowContent) content).afterShow();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.awt.Window#hide()
	 */
	public void hide() {
		invokeBeforeHide();
		super.hide();
		invokeAfterHide();
	}

	/**
	 *  
	 */
	protected void invokeBeforeHide() {
		if (content instanceof WindowContent)
			((WindowContent) content).beforeHide();
	}

	/**
	 *  
	 */
	protected void invokeAfterHide() {
		if (content instanceof WindowContent)
			((WindowContent) content).afterHide();
	}

}