/*
 * brownies and its relative products are published under the terms
 * of the Apache Software License.
 * 
 * Created on 2004/05/27 1:04:01
 */
package org.asyrinx.brownie.swing;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

import org.asyrinx.brownie.swing.content.ContentDialog;
import org.asyrinx.brownie.swing.content.ContentFrame;

/**
 * @author akima
 */
public class SwingUtils {

	public static JFrame showComponentByFrame(Component component, int width,
			int height, String title) {
		final ContentFrame frame = new ContentFrame(component, title);
		frame.setSize(width, height);
		frame.pack();
		frame.show();
		return frame;
	}

	public static JDialog showComponent(Component component, Component owner,
			int width, int height, String title, boolean modal) {
		if (owner instanceof Frame) {
			return showComponent(component, (Frame) owner, width, height,
					title, modal);
		} else if (owner instanceof Dialog) {
			return showComponent(component, (Dialog) owner, width, height,
					title, modal);
		} else {
			final Window window = SwingUtilities.getWindowAncestor(owner);
			if (window instanceof Frame) {
				return showComponent(component, (Frame) window, width, height,
						title, modal);
			} else if (window instanceof Dialog) {
				return showComponent(component, (Dialog) window, width, height,
						title, modal);
			} else {
				throw new GuiRuntimeException(
						"owner and its window don't extended Frame or Dialog.");
			}
		}
	}

	public static JDialog showComponent(Component component, Frame owner,
			int width, int height, String title, boolean modal) {
		final ContentDialog dialog = new ContentDialog(component, owner, title,
				modal);
		dialog.setSize(width, height);
		dialog.pack();
		dialog.show();
		return dialog;
	}

	public static JDialog showComponent(Component component, Dialog owner,
			int width, int height, String title, boolean modal) {
		final ContentDialog dialog = new ContentDialog(component, owner, title,
				modal);
		dialog.setSize(width, height);
		dialog.pack();
		dialog.show();
		return dialog;
	}

}