/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package org.asyrinx.brownie.servlet;

import java.security.Principal;
import java.util.Enumeration;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/**
 * @author Akima
 */
public class HttpServletRequestWrapper extends ServletRequestWrapper implements
		HttpServletRequest {

	/**
	 * Constructor for HttpServletRequestWrapper.
	 * 
	 * @param servletRequest
	 */
	public HttpServletRequestWrapper(HttpServletRequest impl) {
		super(impl);
		this.impl = impl;
	}

	protected final HttpServletRequest impl;

	/**
	 * @see javax.servlet.http.HttpServletRequest#getAuthType()
	 */
	public String getAuthType() {
		return impl.getAuthType();
	}

	/**
	 * @see javax.servlet.http.HttpServletRequest#getCookies()
	 */
	public Cookie[] getCookies() {
		return impl.getCookies();
	}

	/**
	 * @see javax.servlet.http.HttpServletRequest#getDateHeader(String)
	 */
	public long getDateHeader(String name) {
		return impl.getDateHeader(name);
	}

	/**
	 * @see javax.servlet.http.HttpServletRequest#getHeader(String)
	 */
	public String getHeader(String name) {
		return impl.getHeader(name);
	}

	/**
	 * @see javax.servlet.http.HttpServletRequest#getHeaders(String)
	 */
	public Enumeration getHeaders(String name) {
		return impl.getHeaders(name);
	}

	/**
	 * @see javax.servlet.http.HttpServletRequest#getHeaderNames()
	 */
	public Enumeration getHeaderNames() {
		return impl.getHeaderNames();
	}

	/**
	 * @see javax.servlet.http.HttpServletRequest#getIntHeader(String)
	 */
	public int getIntHeader(String name) {
		return impl.getIntHeader(name);
	}

	/**
	 * @see javax.servlet.http.HttpServletRequest#getMethod()
	 */
	public String getMethod() {
		return impl.getMethod();
	}

	/**
	 * @see javax.servlet.http.HttpServletRequest#getPathInfo()
	 */
	public String getPathInfo() {
		return impl.getPathInfo();
	}

	/**
	 * @see javax.servlet.http.HttpServletRequest#getPathTranslated()
	 */
	public String getPathTranslated() {
		return impl.getPathTranslated();
	}

	/**
	 * @see javax.servlet.http.HttpServletRequest#getContextPath()
	 */
	public String getContextPath() {
		return impl.getContextPath();
	}

	/**
	 * @see javax.servlet.http.HttpServletRequest#getQueryString()
	 */
	public String getQueryString() {
		return impl.getQueryString();
	}

	/**
	 * @see javax.servlet.http.HttpServletRequest#getRemoteUser()
	 */
	public String getRemoteUser() {
		return impl.getRemoteUser();
	}

	/**
	 * @see javax.servlet.http.HttpServletRequest#isUserInRole(String)
	 */
	public boolean isUserInRole(String role) {
		return impl.isUserInRole(role);
	}

	/**
	 * @see javax.servlet.http.HttpServletRequest#getUserPrincipal()
	 */
	public Principal getUserPrincipal() {
		return impl.getUserPrincipal();
	}

	/**
	 * @see javax.servlet.http.HttpServletRequest#getRequestedSessionId()
	 */
	public String getRequestedSessionId() {
		return impl.getRequestedSessionId();
	}

	/**
	 * @see javax.servlet.http.HttpServletRequest#getRequestURI()
	 */
	public String getRequestURI() {
		return impl.getRequestURI();
	}

	/**
	 * @see javax.servlet.http.HttpServletRequest#getServletPath()
	 */
	public String getServletPath() {
		return impl.getServletPath();
	}

	/**
	 * @see javax.servlet.http.HttpServletRequest#getSession(boolean)
	 */
	public HttpSession getSession(boolean create) {
		return impl.getSession(create);
	}

	/**
	 * @see javax.servlet.http.HttpServletRequest#getSession()
	 */
	public HttpSession getSession() {
		return impl.getSession();
	}

	/**
	 * @see javax.servlet.http.HttpServletRequest#isRequestedSessionIdValid()
	 */
	public boolean isRequestedSessionIdValid() {
		return impl.isRequestedSessionIdValid();
	}

	/**
	 * @see javax.servlet.http.HttpServletRequest#isRequestedSessionIdFromCookie()
	 */
	public boolean isRequestedSessionIdFromCookie() {
		return impl.isRequestedSessionIdFromCookie();
	}

	/**
	 * @see javax.servlet.http.HttpServletRequest#isRequestedSessionIdFromURL()
	 */
	public boolean isRequestedSessionIdFromURL() {
		return impl.isRequestedSessionIdFromURL();
	}

	/*
	 * private final Logger log =
	 * LoggerFactory.getLog(this.getCharacterEncoding());
	 */

	/**
	 * @see javax.servlet.http.HttpServletRequest#isRequestedSessionIdFromUrl()
	 * @deprecated
	 */
	public boolean isRequestedSessionIdFromUrl() {
		throw new UnsupportedOperationException(
				"isRequestedSessionIdFromUrl()͐܂BisRequestedSessionIdFromURL(URL͑Sđ啶)gpĂB");
		//return impl.isRequestedSessionIdFromUrl();
		//return impl.isRequestedSessionIdFromURL();
	}

	/**
	 * @see javax.servlet.http.HttpServletRequest#getRequestURL()
	 */
	public StringBuffer getRequestURL() {
		return impl.getRequestURL();
	}

}